/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.servicemix.camel.nmr.AbstractComponentTest;
import org.junit.Test;

public class SimpleNmrTest
extends AbstractComponentTest {
    private static final String REQUEST_MESSAGE = "Simple message body";
    private static final String RESPONSE_MESSAGE = "Simple message reply";

    @Test
    public void testSimpleInOnly() throws InterruptedException {
        MockEndpoint mock = this.getMockEndpoint("mock:simple");
        mock.expectedBodiesReceived(new Object[]{REQUEST_MESSAGE});
        this.template.sendBody("direct:simple", (Object)REQUEST_MESSAGE);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSimpleInOnlyWithMultipleHops() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:hops");
        mock.expectedBodiesReceived(new Object[]{REQUEST_MESSAGE});
        this.template.sendBody("direct:hops", (Object)REQUEST_MESSAGE);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSimpleInOut() throws InterruptedException {
        MockEndpoint mock = this.getMockEndpoint("mock:simple");
        mock.expectedBodiesReceived(new Object[]{REQUEST_MESSAGE});
        String response = (String)this.template.requestBody("direct:simple", (Object)REQUEST_MESSAGE, String.class);
        this.assertMockEndpointsSatisfied();
        SimpleNmrTest.assertEquals((String)"Receiving back the reply set by the second route", (Object)RESPONSE_MESSAGE, (Object)response);
    }

    @Test
    public void testSimpleInOutWithMultipleHops() throws InterruptedException {
        MockEndpoint mock = this.getMockEndpoint("mock:hops");
        mock.expectedBodiesReceived(new Object[]{REQUEST_MESSAGE});
        String response = (String)this.template.requestBody("direct:hops", (Object)REQUEST_MESSAGE, String.class);
        this.assertMockEndpointsSatisfied();
        SimpleNmrTest.assertEquals((String)"Receiving back the reply set by the second route", (Object)RESPONSE_MESSAGE, (Object)response);
    }

    @Test
    public void testSimpleInvalidEndpoint() throws InterruptedException {
        Exchange exchange = this.template.send("direct:error", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)SimpleNmrTest.REQUEST_MESSAGE);
            }
        });
        SimpleNmrTest.assertTrue((String)"Sending to an invalid NMR endpoint should have failed", (boolean)exchange.isFailed());
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:simple").to("nmr:simple");
                ((RouteDefinition)this.from("nmr:simple").to("mock:simple")).setBody((Expression)this.constant(SimpleNmrTest.RESPONSE_MESSAGE));
                this.from("direct:hops").to("nmr:hop1");
                this.from("nmr:hop1").to("nmr:hop2");
                ((RouteDefinition)this.from("nmr:hop2").to("mock:hops")).setBody((Expression)this.constant(SimpleNmrTest.RESPONSE_MESSAGE));
                this.from("direct:error").to("nmr:invalid-endpoint-name");
            }
        };
    }
}

