/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr;

import java.security.AccessController;
import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.servicemix.camel.nmr.AbstractComponentTest;
import org.apache.servicemix.nmr.api.security.UserPrincipal;
import org.junit.Assert;
import org.junit.Test;

public class RunAsSubjectTest
extends AbstractComponentTest {
    private static final String REQUEST_MESSAGE = "Simple message body";

    @Test
    public void testRunAsSubject() throws InterruptedException {
        MockEndpoint mock = this.getMockEndpoint("mock:caught");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:inonly", (Object)REQUEST_MESSAGE);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                Subject subject = new Subject();
                subject.getPrincipals().add((Principal)new UserPrincipal("ffang"));
                ((ProcessorDefinition)this.from("direct:inonly").setHeader("CamelAuthentication").constant((Object)subject)).to("nmr:helloworld");
                this.from("nmr:helloworld?runAsSubject=true").process((Processor)new SubjectProcessor());
            }
        };
    }

    class SubjectProcessor
    implements Processor {
        SubjectProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            Subject receivedSubject = (Subject)exchange.getIn().getHeader("CamelAuthentication");
            Assert.assertNotNull((Object)receivedSubject);
            Assert.assertEquals((long)receivedSubject.getPrincipals().size(), (long)1L);
            Assert.assertEquals((Object)receivedSubject.getPrincipals().iterator().next().getName(), (Object)"ffang");
            Subject onBefalfsubject = Subject.getSubject(AccessController.getContext());
            Assert.assertNotNull((Object)onBefalfsubject);
            Assert.assertEquals((Object)onBefalfsubject, (Object)receivedSubject);
        }
    }
}

