/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.servicemix.camel.nmr.AbstractComponentTest;
import org.junit.Assert;
import org.junit.Test;

public class MultipleProducersTest
extends AbstractComponentTest {
    private static final int COUNT = 100;

    @Test
    public void testConcurrentlyUsingTheSameProducerName() throws InterruptedException {
        this.getMockEndpoint("mock:handler").expectedMessageCount(200);
        ExecutorService executor = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 100; ++i) {
            executor.execute(new Runnable(){

                public void run() {
                    Assert.assertEquals((Object)"Replying to Guillaume", (Object)MultipleProducersTest.this.template.requestBody("direct:a", (Object)"Guillaume"));
                }
            });
            executor.execute(new Runnable(){

                public void run() {
                    Assert.assertEquals((Object)"Replying to Chris", (Object)MultipleProducersTest.this.template.requestBody("direct:a", (Object)"Chris"));
                }
            });
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:a").to("nmr:handler");
                this.from("direct:b").to("nmr:handler");
                ((RouteDefinition)this.from("nmr:handler").setBody((Expression)this.simple("Replying to ${body}"))).to("mock:handler");
            }
        };
    }
}

