/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr;

import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javax.naming.Context;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Endpoint;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.cxf.transport.CamelTransportFactory;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.test.CamelTestSupport;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.hello_world_soap_http.BadRecordLitFault;
import org.apache.hello_world_soap_http.Greeter;
import org.apache.hello_world_soap_http.GreeterImpl;
import org.apache.hello_world_soap_http.NoSuchCodeLitFault;
import org.apache.hello_world_soap_http.SOAPService;
import org.apache.servicemix.camel.nmr.ServiceMixComponent;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.core.ServiceMix;

public class ExceptionHandleTest
extends CamelTestSupport {
    protected static final String ROUTER_ADDRESS = "camel://jetty:http://localhost:19000/SoapContext/SoapPort";
    protected static final String SERVICE_ADDRESS = "local://smx/hello_world";
    protected static final String SERVICE_CLASS = "serviceClass=org.apache.hello_world_soap_http.Greeter";
    private static final String WSDL_LOCATION = "wsdlURL=/wsdl/hello_world.wsdl";
    private static final String SERVICE_NAME = "serviceName={http://apache.org/hello_world_soap_http}SOAPService";
    private String routerEndpointURI = "cxf://camel://jetty:http://localhost:19000/SoapContext/SoapPort?serviceClass=org.apache.hello_world_soap_http.Greeter&wsdlURL=/wsdl/hello_world.wsdl&serviceName={http://apache.org/hello_world_soap_http}SOAPService&dataFormat=POJO&bus=#Bus";
    private String serviceEndpointURI = "cxf://local://smx/hello_world?serviceClass=org.apache.hello_world_soap_http.Greeter&wsdlURL=/wsdl/hello_world.wsdl&serviceName={http://apache.org/hello_world_soap_http}SOAPService&dataFormat=POJO&bus=#Bus";
    private CamelContext camelContext;
    private ServiceMixComponent smxComponent;
    private NMR nmr;
    private Endpoint endpoint;

    protected void setUp() throws Exception {
        super.setUp();
        GreeterImpl implementor = new GreeterImpl();
        this.endpoint = Endpoint.publish((String)SERVICE_ADDRESS, (Object)implementor);
    }

    protected void tearDown() throws Exception {
        if (this.camelContext != null) {
            this.camelContext.stop();
        }
        if (this.endpoint != null) {
            this.endpoint.stop();
        }
        super.tearDown();
        Thread.sleep(5000L);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.noErrorHandler());
                this.from(ExceptionHandleTest.this.routerEndpointURI).to("smx:testEndpoint");
                this.from("smx:testEndpoint").to(ExceptionHandleTest.this.serviceEndpointURI);
            }
        };
    }

    protected CamelContext createCamelContext() throws Exception {
        this.camelContext = new DefaultCamelContext(this.createJndiContext());
        Bus bus = BusFactory.getDefaultBus();
        CamelTransportFactory camelTransportFactory = (CamelTransportFactory)((ConduitInitiatorManager)bus.getExtension(ConduitInitiatorManager.class)).getConduitInitiator("http://cxf.apache.org/transports/camel");
        camelTransportFactory.setCamelContext(this.camelContext);
        ArrayList<String> ids = new ArrayList<String>();
        ids.add("http://cxf.apache.org/transports/camel");
        camelTransportFactory.setTransportIds(ids);
        this.smxComponent = new ServiceMixComponent();
        this.nmr = new ServiceMix();
        ((ServiceMix)this.nmr).init();
        this.smxComponent.setNmr(this.nmr);
        this.camelContext.addComponent("smx", (Component)this.smxComponent);
        return this.camelContext;
    }

    protected Context createJndiContext() throws Exception {
        Context ctx = super.createJndiContext();
        ctx.bind("Bus", (Object)BusFactory.getDefaultBus());
        return ctx;
    }

    public void testException() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        ExceptionHandleTest.assertNotNull((Object)wsdl);
        SOAPService service1 = new SOAPService(wsdl, new QName("http://apache.org/hello_world_soap_http", "SOAPService"));
        QName endpoint = new QName("http://apache.org/hello_world_soap_http", "SoapPort");
        service1.addPort(endpoint, "http://www.w3.org/2003/05/soap/bindings/HTTP/", "http://localhost:19000/SoapContext/SoapPort");
        Greeter greeter = (Greeter)service1.getPort(endpoint, Greeter.class);
        ClientProxy.getClient((Object)greeter).getInInterceptors().add(new LoggingInInterceptor());
        ClientProxy.getClient((Object)greeter).getOutInterceptors().add(new LoggingOutInterceptor());
        String ret = greeter.sayHi();
        ExceptionHandleTest.assertEquals((String)ret, (String)"Bonjour");
        String noSuchCodeFault = "NoSuchCodeLitFault";
        String badRecordFault = "BadRecordLitFault";
        try {
            greeter.testDocLitFault(noSuchCodeFault);
            ExceptionHandleTest.fail((String)"Should have thrown NoSuchCodeLitFault exception");
        }
        catch (NoSuchCodeLitFault nslf) {
            ExceptionHandleTest.assertNotNull((Object)nslf.getFaultInfo());
            ExceptionHandleTest.assertNotNull((Object)nslf.getFaultInfo().getCode());
        }
        try {
            greeter.testDocLitFault(badRecordFault);
            ExceptionHandleTest.fail((String)"Should have thrown BadRecordLitFault exception");
        }
        catch (BadRecordLitFault brlf) {
            BindingProvider bp = (BindingProvider)greeter;
            Map responseContext = bp.getResponseContext();
            Integer responseCode = (Integer)responseContext.get(Message.RESPONSE_CODE);
            ExceptionHandleTest.assertEquals((int)500, (int)responseCode);
            ExceptionHandleTest.assertNotNull((Object)brlf.getFaultInfo());
            ExceptionHandleTest.assertEquals((String)"BadRecordLitFault", (String)brlf.getFaultInfo());
        }
    }

    public void testOneway() throws Exception {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/hello_world.wsdl");
        ExceptionHandleTest.assertNotNull((Object)wsdl);
        SOAPService service1 = new SOAPService(wsdl, new QName("http://apache.org/hello_world_soap_http", "SOAPService"));
        QName endpoint = new QName("http://apache.org/hello_world_soap_http", "SoapPort");
        service1.addPort(endpoint, "http://www.w3.org/2003/05/soap/bindings/HTTP/", "http://localhost:19000/SoapContext/SoapPort");
        Greeter greeter = (Greeter)service1.getPort(endpoint, Greeter.class);
        ClientProxy.getClient((Object)greeter).getInInterceptors().add(new LoggingInInterceptor());
        ClientProxy.getClient((Object)greeter).getOutInterceptors().add(new LoggingOutInterceptor());
        greeter.greetMeOneWay("test oneway");
        Thread.sleep(1000L);
    }

    public void testGetTransportFactoryFromBus() throws Exception {
        Bus bus = BusFactory.getDefaultBus();
        ExceptionHandleTest.assertNotNull((Object)((ConduitInitiatorManager)bus.getExtension(ConduitInitiatorManager.class)).getConduitInitiator("http://cxf.apache.org/transports/camel"));
    }
}

