/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import javax.xml.ws.Holder;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.test.CamelSpringTestSupport;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.servicemix.camel.nmr.PersonImpl;
import org.apache.servicemix.samples.wsdl_first.Person;
import org.apache.servicemix.samples.wsdl_first.PersonService;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class CxfMessageTest
extends CamelSpringTestSupport {
    private ServerImpl server;

    protected void setUp() throws Exception {
        super.setUp();
        this.startService();
    }

    protected ClassPathXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/servicemix/camel/spring/CxfMessageBeans.xml");
    }

    protected void assertValidContext(CamelContext context) {
        CxfMessageTest.assertNotNull((String)"No context found!", (Object)context);
    }

    protected void startService() {
        PersonImpl implementor = new PersonImpl();
        String address = "http://localhost:19000/PersonService/";
        Endpoint.publish((String)address, (Object)implementor);
    }

    protected void tearDown() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        super.tearDown();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
            }
        };
    }

    public void testInvokingServiceFromCXFClient() throws Exception {
        URL wsdlURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("person.wsdl");
        System.out.println(wsdlURL);
        PersonService ss = new PersonService(wsdlURL, new QName("http://servicemix.apache.org/samples/wsdl-first", "PersonService"));
        Person client = ss.getSoap();
        ClientProxy.getClient((Object)client).getOutInterceptors().add(new LoggingOutInterceptor());
        ClientProxy.getClient((Object)client).getInInterceptors().add(new LoggingInInterceptor());
        Holder personId = new Holder();
        personId.value = "world";
        Holder ssn = new Holder();
        Holder name = new Holder();
        client.getPerson((Holder<String>)personId, (Holder<String>)ssn, (Holder<String>)name);
        CxfMessageTest.assertEquals((String)"we should get the right answer from router", (String)"Bonjour", (String)((String)name.value));
    }
}

