/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr;

import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.test.CamelTestSupport;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxws.JaxWsClientProxy;
import org.apache.cxf.jaxws.binding.soap.SOAPBindingImpl;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.mime.TestMtom;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.servicemix.camel.nmr.MtomImpl;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentTest
extends CamelTestSupport {
    protected static final String SERVICE_ADDRESS = "local://smx/attachment";
    protected static final String ROUTER_ADDRESS = "http://localhost:9036/mime-test";
    protected static final String SERVICE_CLASS = "serviceClass=org.apache.cxf.mime.TestMtom";
    public static final QName MTOM_PORT = new QName("http://cxf.apache.org/mime", "TestMtomPort");
    public static final QName MTOM_SERVICE = new QName("http://cxf.apache.org/mime", "TestMtomService");
    protected AbstractXmlApplicationContext applicationContext;

    protected void setUp() throws Exception {
        this.applicationContext = this.createApplicationContext();
        super.setUp();
        AttachmentTest.assertNotNull((String)"Should have created a valid spring context", (Object)this.applicationContext);
        this.startService();
    }

    protected void tearDown() throws Exception {
        if (this.applicationContext != null) {
            this.applicationContext.destroy();
        }
        super.tearDown();
    }

    protected void startService() {
        MtomImpl implementor = new MtomImpl();
        javax.xml.ws.Endpoint.publish((String)SERVICE_ADDRESS, (Object)implementor);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("cxf:bean:routerEndpoint").to("smx:testEndpoint");
                this.from("smx:testEndpoint").to("cxf:bean:serviceEndpoint");
            }
        };
    }

    protected CamelContext createCamelContext() throws Exception {
        return SpringCamelContext.springCamelContext((ApplicationContext)this.applicationContext);
    }

    protected ClassPathXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/servicemix/camel/spring/mtom.xml");
    }

    public void testAttachment() throws Exception {
        TestMtom mtomPort = this.createPort(MTOM_SERVICE, MTOM_PORT, TestMtom.class, true);
        try {
            Holder param = new Holder();
            param.value = new DataHandler((DataSource)new ByteArrayDataSource("foobar".getBytes(), "application/octet-stream"));
            Holder name = new Holder((Object)"call detail");
            mtomPort.testXop(name, param);
            AttachmentTest.assertEquals((String)"call detailfoobar", (String)((String)name.value));
            AttachmentTest.assertNotNull((Object)param.value);
            InputStream bis = ((DataHandler)param.value).getDataSource().getInputStream();
            byte[] b = new byte[10];
            bis.read(b, 0, 10);
            String attachContent = new String(b);
            AttachmentTest.assertEquals((String)attachContent, (String)"testfoobar");
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    private <T> T createPort(QName serviceName, QName portName, Class<T> serviceEndpointInterface, boolean enableMTOM) throws Exception {
        Bus bus = BusFactory.getDefaultBus();
        JaxWsServiceFactoryBean serviceFactory = new JaxWsServiceFactoryBean();
        serviceFactory.setBus(bus);
        serviceFactory.setServiceName(serviceName);
        serviceFactory.setServiceClass(serviceEndpointInterface);
        serviceFactory.setWsdlURL(((Object)((Object)this)).getClass().getResource("/wsdl/mtom_xop.wsdl"));
        Service service = serviceFactory.create();
        EndpointInfo ei = service.getEndpointInfo(portName);
        JaxWsEndpointImpl jaxwsEndpoint = new JaxWsEndpointImpl(bus, service, ei);
        SOAPBindingImpl jaxWsSoapBinding = new SOAPBindingImpl(ei.getBinding(), jaxwsEndpoint);
        jaxWsSoapBinding.setMTOMEnabled(enableMTOM);
        ClientImpl client = new ClientImpl(bus, (Endpoint)jaxwsEndpoint);
        JaxWsClientProxy ih = new JaxWsClientProxy((Client)client, jaxwsEndpoint.getJaxwsBinding());
        Object obj = Proxy.newProxyInstance(serviceEndpointInterface.getClassLoader(), new Class[]{serviceEndpointInterface, BindingProvider.class}, (InvocationHandler)ih);
        return serviceEndpointInterface.cast(obj);
    }
}

