/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr.ws.security;

import java.net.URL;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import javax.xml.ws.Service;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.test.CamelTestSupport;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.hello_world_soap_http.Greeter;
import org.apache.servicemix.camel.nmr.ServiceMixComponent;
import org.apache.servicemix.camel.nmr.ws.security.GreeterImpl;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.core.ServiceMix;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class WSSecurityTest
extends CamelTestSupport {
    private static final Logger LOG = LogUtils.getL7dLogger(WSSecurityTest.class);
    private static final URL WSDL_LOC;
    protected static final String SERVICE_ADDRESS = "local://smx/hello_world";
    protected AbstractXmlApplicationContext applicationContext;
    private ServerImpl server;
    private CamelContext camelContext;
    private ServiceMixComponent smxComponent;
    private NMR nmr;

    protected void setUp() throws Exception {
        this.applicationContext = this.createApplicationContext();
        super.setUp();
        this.startService();
    }

    protected void startService() {
        GreeterImpl implementor = new GreeterImpl();
        Endpoint.publish((String)SERVICE_ADDRESS, (Object)((Object)implementor));
    }

    protected void tearDown() throws Exception {
        if (this.applicationContext != null) {
            this.applicationContext.destroy();
        }
        if (this.server != null) {
            this.server.stop();
        }
        super.tearDown();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("cxf:bean:routerEndpoint").to("smx:testEndpoint");
                this.from("smx:testEndpoint").to("cxf:bean:serviceEndpoint");
            }
        };
    }

    protected CamelContext createCamelContext() throws Exception {
        this.camelContext = SpringCamelContext.springCamelContext((ApplicationContext)this.applicationContext);
        this.smxComponent = new ServiceMixComponent();
        this.nmr = new ServiceMix();
        ((ServiceMix)this.nmr).init();
        this.smxComponent.setNmr(this.nmr);
        this.camelContext.addComponent("smx", (Component)this.smxComponent);
        return this.camelContext;
    }

    protected ClassPathXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/servicemix/camel/ws/security/server.xml");
    }

    public void testTimestampSignEncrypt() {
        LOG.info("test security");
        Bus bus = new SpringBusFactory().createBus("org/apache/servicemix/camel/ws/security/client.xml");
        BusFactory.setDefaultBus((Bus)bus);
        LoggingInInterceptor in = new LoggingInInterceptor();
        bus.getInInterceptors().add(in);
        bus.getInFaultInterceptors().add(in);
        LoggingOutInterceptor out = new LoggingOutInterceptor();
        bus.getOutInterceptors().add(out);
        bus.getOutFaultInterceptors().add(out);
        Service svc = Service.create((URL)WSDL_LOC, (QName)new QName("http://apache.org/hello_world_soap_http", "SOAPServiceWSSecurity"));
        Greeter greeter = (Greeter)svc.getPort(new QName("http://apache.org/hello_world_soap_http", "TimestampSignEncrypt"), Greeter.class);
        String ret = greeter.sayHi();
        WSSecurityTest.assertEquals((String)ret, (String)"Bonjour");
        ret = greeter.greetMe("ffang");
        WSSecurityTest.assertEquals((String)ret, (String)"Hello ffang");
    }

    static {
        URL tmp = null;
        try {
            tmp = WSSecurityTest.class.getClassLoader().getResource("org/apache/servicemix/camel/ws/security/hello_world.wsdl");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        WSDL_LOC = tmp;
    }
}

