/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr.ws.addressing;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import javax.xml.ws.Service;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.test.CamelTestSupport;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxws.ServiceImpl;
import org.apache.cxf.jaxws.support.ServiceDelegateAccessor;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.ReferenceParametersType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.apache.hello_world_soap_http.BadRecordLitFault;
import org.apache.hello_world_soap_http.Greeter;
import org.apache.hello_world_soap_http.NoSuchCodeLitFault;
import org.apache.hello_world_soap_http.SOAPService;
import org.apache.servicemix.camel.nmr.ServiceMixComponent;
import org.apache.servicemix.camel.nmr.ws.addressing.GreeterImpl;
import org.apache.servicemix.camel.nmr.ws.addressing.HeaderVerifier;
import org.apache.servicemix.camel.nmr.ws.addressing.MAPVerifier;
import org.apache.servicemix.camel.nmr.ws.addressing.VerificationCache;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.core.ServiceMix;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSAddressingTest
extends CamelTestSupport
implements VerificationCache {
    protected static final String SERVICE_ADDRESS = "local://smx/hello_world";
    static final String INBOUND_KEY = "inbound";
    static final String OUTBOUND_KEY = "outbound";
    static final String ADDRESS = "http://localhost:9008/SoapContext/SoapPort";
    static final QName CUSTOMER_NAME = new QName("http://example.org/customer", "CustomerKey", "customer");
    static final String CUSTOMER_KEY = "Key#123456789";
    private static Bus staticBus;
    private static MAPVerifier mapVerifier;
    private static HeaderVerifier headerVerifier;
    private static final QName SERVICE_NAME;
    private static final URL WSDL_LOC;
    private static final String CONFIG;
    private static Map<Object, Map<String, String>> messageIDs;
    protected Greeter greeter;
    private String verified;
    protected AbstractXmlApplicationContext applicationContext;
    private ServerImpl server;
    private CamelContext camelContext;
    private ServiceMixComponent smxComponent;
    private NMR nmr;
    private Endpoint endpoint;

    protected void setUp() throws Exception {
        this.applicationContext = this.createApplicationContext();
        super.setUp();
        this.startService();
        if (staticBus == null) {
            SpringBusFactory bf = new SpringBusFactory();
            staticBus = bf.createBus(this.getConfigFileName());
        }
        messageIDs.clear();
        mapVerifier = new MAPVerifier();
        headerVerifier = new HeaderVerifier();
        Interceptor[] interceptors = new Interceptor[]{mapVerifier, headerVerifier};
        this.addInterceptors(staticBus.getInInterceptors(), interceptors);
        this.addInterceptors(staticBus.getOutInterceptors(), interceptors);
        this.addInterceptors(staticBus.getOutFaultInterceptors(), interceptors);
        this.addInterceptors(staticBus.getInFaultInterceptors(), interceptors);
        EndpointReferenceType target = EndpointReferenceUtils.getEndpointReference((String)ADDRESS);
        ReferenceParametersType params = ContextUtils.WSA_OBJECT_FACTORY.createReferenceParametersType();
        JAXBElement param = new JAXBElement(CUSTOMER_NAME, String.class, (Object)CUSTOMER_KEY);
        params.getAny().add(param);
        target.setReferenceParameters(params);
        ServiceImpl serviceImpl = ServiceDelegateAccessor.get((Service)new SOAPService(WSDL_LOC, SERVICE_NAME));
        this.greeter = (Greeter)serviceImpl.getPort(target, Greeter.class);
        WSAddressingTest.mapVerifier.verificationCache = this;
        WSAddressingTest.headerVerifier.verificationCache = this;
    }

    protected void startService() {
        GreeterImpl implementor = new GreeterImpl();
        this.endpoint = Endpoint.publish((String)SERVICE_ADDRESS, (Object)implementor);
    }

    protected void tearDown() throws Exception {
        if (this.applicationContext != null) {
            this.applicationContext.destroy();
        }
        if (this.server != null) {
            this.server.stop();
        }
        if (this.endpoint != null) {
            this.endpoint.stop();
        }
        Interceptor[] interceptors = new Interceptor[]{mapVerifier, headerVerifier};
        this.removeInterceptors(staticBus.getInInterceptors(), interceptors);
        this.removeInterceptors(staticBus.getOutInterceptors(), interceptors);
        this.removeInterceptors(staticBus.getOutFaultInterceptors(), interceptors);
        this.removeInterceptors(staticBus.getInFaultInterceptors(), interceptors);
        mapVerifier = null;
        headerVerifier = null;
        this.verified = null;
        messageIDs.clear();
        super.tearDown();
        BusFactory.setDefaultBus(null);
        Thread.sleep(5000L);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.noErrorHandler());
                this.from("cxf:bean:routerEndpoint").to("smx:testEndpoint");
                this.from("smx:testEndpoint").to("cxf:bean:serviceEndpoint");
            }
        };
    }

    protected CamelContext createCamelContext() throws Exception {
        this.camelContext = SpringCamelContext.springCamelContext((ApplicationContext)this.applicationContext);
        this.smxComponent = new ServiceMixComponent();
        this.nmr = new ServiceMix();
        ((ServiceMix)this.nmr).init();
        this.smxComponent.setNmr(this.nmr);
        this.camelContext.addComponent("smx", (Component)this.smxComponent);
        return this.camelContext;
    }

    protected ClassPathXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/servicemix/camel/ws/addressing/server.xml");
    }

    public void testImplicitMAPs() throws Exception {
        try {
            String greeting = this.greeter.greetMe("implicit1");
            WSAddressingTest.assertEquals((String)"unexpected response received from service", (String)"Hello implicit1", (String)greeting);
            this.checkVerification();
            greeting = this.greeter.greetMe("implicit2");
            WSAddressingTest.assertEquals((String)"unexpected response received from service", (String)"Hello implicit2", (String)greeting);
            this.checkVerification();
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    public void testOneway() throws Exception {
        try {
            this.greeter.greetMeOneWay("implicit_oneway1");
            this.checkVerification();
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    public void testApplicationFault() throws Exception {
        try {
            this.greeter.testDocLitFault("BadRecordLitFault");
            WSAddressingTest.fail((String)"expected fault from service");
        }
        catch (BadRecordLitFault brlf) {
            this.checkVerification();
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
        String greeting = this.greeter.greetMe("intra-fault");
        WSAddressingTest.assertEquals((String)"unexpected response received from service", (String)"Hello intra-fault", (String)greeting);
        try {
            this.greeter.testDocLitFault("NoSuchCodeLitFault");
            WSAddressingTest.fail((String)"expected NoSuchCodeLitFault");
        }
        catch (NoSuchCodeLitFault nsclf) {
            this.checkVerification();
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    public void testVersioning() throws Exception {
        try {
            WSAddressingTest.mapVerifier.expectedExposedAs.add("http://schemas.xmlsoap.org/ws/2004/08/addressing");
            WSAddressingTest.mapVerifier.expectedExposedAs.add("http://schemas.xmlsoap.org/ws/2004/08/addressing");
            String greeting = this.greeter.greetMe("versioning1");
            WSAddressingTest.assertEquals((String)"unexpected response received from service", (String)"Hello versioning1", (String)greeting);
            this.checkVerification();
            greeting = this.greeter.greetMe("versioning2");
            WSAddressingTest.assertEquals((String)"unexpected response received from service", (String)"Hello versioning2", (String)greeting);
            this.checkVerification();
        }
        catch (UndeclaredThrowableException ex) {
            throw (Exception)ex.getCause();
        }
    }

    protected static String verifyMAPs(AddressingProperties maps, Object checkPoint) {
        if (maps == null) {
            return "expected MAPs";
        }
        String id = maps.getMessageID().getValue();
        if (id == null) {
            return "expected MessageID MAP";
        }
        if (!id.startsWith("urn:uuid")) {
            return "bad URN format in MessageID MAP: " + id;
        }
        Map<String, String> checkPointMessageIDs = messageIDs.get(checkPoint);
        if (checkPointMessageIDs != null) {
            if (checkPointMessageIDs.containsKey(id)) {
                return null;
            }
        } else {
            checkPointMessageIDs = new HashMap<String, String>();
            messageIDs.put(checkPoint, checkPointMessageIDs);
        }
        checkPointMessageIDs.put(id, id);
        if (maps.getTo() == null) {
            return "expected To MAP";
        }
        return null;
    }

    public String getConfigFileName() {
        return CONFIG;
    }

    public static void shutdownBus() throws Exception {
        staticBus.shutdown(true);
    }

    private void addInterceptors(List<Interceptor<? extends Message>> chain, Interceptor[] interceptors) {
        for (int i = 0; i < interceptors.length; ++i) {
            chain.add((Interceptor<? extends Message>)interceptors[i]);
        }
    }

    private void removeInterceptors(List<Interceptor<? extends Message>> chain, Interceptor[] interceptors) {
        for (int i = 0; i < interceptors.length; ++i) {
            chain.add((Interceptor<? extends Message>)interceptors[i]);
        }
    }

    @Override
    public void put(String verification) {
        if (verification != null) {
            this.verified = this.verified == null ? verification : this.verified + "; " + verification;
        }
    }

    protected static String verifyHeaders(List<String> wsaHeaders, boolean partial, boolean requestLeg) {
        String ret = null;
        if (!wsaHeaders.contains("MessageID")) {
            ret = "expected MessageID header";
        }
        if (!wsaHeaders.contains("To")) {
            ret = "expected To header";
        }
        if (!wsaHeaders.contains("ReplyTo") && !wsaHeaders.contains("RelatesTo")) {
            ret = "expected ReplyTo or RelatesTo header";
        }
        if (!partial || !wsaHeaders.contains("From")) {
            // empty if block
        }
        if (requestLeg && !wsaHeaders.contains(CUSTOMER_NAME.getLocalPart())) {
            ret = "expected CustomerKey header";
        }
        return ret;
    }

    private void checkVerification() {
        WSAddressingTest.assertNull((String)("MAP/Header verification failed: " + this.verified), (Object)this.verified);
    }

    static {
        SERVICE_NAME = new QName("http://apache.org/hello_world_soap_http", "SOAPServiceAddressing");
        messageIDs = new HashMap<Object, Map<String, String>>();
        CONFIG = "org/apache/servicemix/camel/ws/addressing/addressing" + ("HP-UX".equals(System.getProperty("os.name")) || "Windows XP".equals(System.getProperty("os.name")) ? "-hpux" : "") + ".xml";
        URL tmp = null;
        try {
            tmp = WSAddressingTest.class.getClassLoader().getResource("org/apache/servicemix/camel/ws/addressing/hello_world.wsdl");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        WSDL_LOC = tmp;
    }
}

