/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr;

import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.test.CamelSpringTestSupport;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.CXFBusFactory;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.frontend.ClientProxyFactoryBean;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.servicemix.camel.nmr.HelloService;
import org.apache.servicemix.camel.nmr.HelloServiceImpl;
import org.springframework.beans.BeansException;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SmxToCxfTest
extends CamelSpringTestSupport {
    private static final String BUS_BEAN_NAME = "Bus";
    protected static final String ROUTER_ADDRESS = "http://localhost:19000/router";
    protected static final String SERVICE_ADDRESS = "local://smx/helloworld";
    protected static final String SERVICE_CLASS = "serviceClass=org.apache.servicemix.camel.nmr.HelloService";
    private String routerEndpointURI = String.format("cxf://%s?%s&dataFormat=POJO&setDefaultBus=true&bus=#%s", "http://localhost:19000/router", "serviceClass=org.apache.servicemix.camel.nmr.HelloService", "Bus");
    private String serviceEndpointURI = String.format("cxf://%s?%s&dataFormat=POJO&setDefaultBus=true&bus=#%s", "local://smx/helloworld", "serviceClass=org.apache.servicemix.camel.nmr.HelloService", "Bus");
    private ServerImpl server;
    private Bus bus;

    protected void setUp() throws Exception {
        this.bus = CXFBusFactory.getDefaultBus();
        super.setUp();
        this.startService();
    }

    protected ClassPathXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/servicemix/camel/spring/DummyBean.xml"){

            public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
                if (SmxToCxfTest.BUS_BEAN_NAME.equals(name)) {
                    return requiredType.cast(SmxToCxfTest.this.bus);
                }
                return (T)super.getBean(name, requiredType);
            }
        };
    }

    protected void assertValidContext(CamelContext context) {
        SmxToCxfTest.assertNotNull((String)"No context found!", (Object)context);
    }

    protected void startService() {
        ServerFactoryBean svrBean = new ServerFactoryBean();
        svrBean.setAddress(SERVICE_ADDRESS);
        svrBean.setServiceClass(HelloService.class);
        svrBean.setServiceBean((Object)new HelloServiceImpl());
        svrBean.setBus(CXFBusFactory.getDefaultBus());
        this.server = (ServerImpl)svrBean.create();
        this.server.start();
    }

    protected void tearDown() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        super.tearDown();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(SmxToCxfTest.this.routerEndpointURI).to("smx:testEndpoint");
                this.from("smx:testEndpoint").to(SmxToCxfTest.this.serviceEndpointURI);
            }
        };
    }

    public void testInvokingServiceFromCXFClient() throws Exception {
        Bus bus = BusFactory.getDefaultBus();
        ClientProxyFactoryBean proxyFactory = new ClientProxyFactoryBean();
        ClientFactoryBean clientBean = proxyFactory.getClientFactoryBean();
        clientBean.setAddress(ROUTER_ADDRESS);
        clientBean.setServiceClass(HelloService.class);
        clientBean.setBus(bus);
        HelloService client = (HelloService)proxyFactory.create();
        String result = client.echo("hello world");
        SmxToCxfTest.assertEquals((String)"we should get the right answer from router", (String)"hello world echo", (String)result);
    }
}

