/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.servicemix.camel.nmr.AbstractComponentTest;
import org.junit.Test;

public class ShouldRunSynchronouslyTest
extends AbstractComponentTest {
    private static final String HANDLED_BY_THREAD = "HandledByThread";

    @Test
    public void testProcessingOnSameThread() throws InterruptedException {
        MockEndpoint mock = this.getMockEndpoint("mock:simple");
        mock.expectedBodiesReceived(new Object[]{"Simple message body"});
        template.sendBody("direct:simple", (Object)"Simple message body");
        this.assertMockEndpointsSatisfied();
        Thread thread = (Thread)((Exchange)mock.getExchanges().get(0)).getProperty(HANDLED_BY_THREAD, Thread.class);
        ShouldRunSynchronouslyTest.assertNotNull((Object)thread);
        ShouldRunSynchronouslyTest.assertEquals((String)"No thread context switching should have occurred", (Object)Thread.currentThread(), (Object)thread);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:simple").to("nmr:simple");
                ((RouteDefinition)this.from("nmr:simple?synchronous=true").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.setProperty(ShouldRunSynchronouslyTest.HANDLED_BY_THREAD, (Object)Thread.currentThread());
                    }
                })).to("mock:simple");
            }
        };
    }
}

