/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr;

import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.servicemix.camel.nmr.AbstractComponentTest;
import org.apache.servicemix.camel.nmr.ServiceMixEndpoint;
import org.junit.Test;

public class ServiceMixComponentTest
extends AbstractComponentTest {
    private final CamelContext context = new DefaultCamelContext();

    @Test
    public void testSimpleUri() {
        ServiceMixEndpoint endpoint = (ServiceMixEndpoint)this.context.getEndpoint("nmr:Test");
        ServiceMixComponentTest.assertNotNull((Object)endpoint);
    }

    @Test
    public void testUriRunAsSubject() {
        ServiceMixEndpoint endpoint = (ServiceMixEndpoint)this.context.getEndpoint("nmr:Test");
        ServiceMixComponentTest.assertNotNull((Object)endpoint);
        ServiceMixComponentTest.assertFalse((boolean)endpoint.isRunAsSubject());
        endpoint = (ServiceMixEndpoint)this.context.getEndpoint("nmr:Test?runAsSubject=false");
        ServiceMixComponentTest.assertNotNull((Object)endpoint);
        ServiceMixComponentTest.assertFalse((boolean)endpoint.isRunAsSubject());
        endpoint = (ServiceMixEndpoint)this.context.getEndpoint("nmr:Test?runAsSubject=true");
        ServiceMixComponentTest.assertNotNull((Object)endpoint);
        ServiceMixComponentTest.assertTrue((boolean)endpoint.isRunAsSubject());
    }

    @Test
    public void testUriTimeOut() {
        ServiceMixEndpoint endpoint = (ServiceMixEndpoint)this.context.getEndpoint("nmr:Test");
        ServiceMixComponentTest.assertNotNull((Object)endpoint);
        ServiceMixComponentTest.assertEquals((Object)new Long(0L), (Object)endpoint.getTimeOut());
        endpoint = (ServiceMixEndpoint)this.context.getEndpoint("nmr:Test?timeout=3000");
        ServiceMixComponentTest.assertNotNull((Object)endpoint);
        ServiceMixComponentTest.assertEquals((Object)new Long(3000L), (Object)endpoint.getTimeOut());
    }
}

