/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr;

import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.servicemix.camel.nmr.AbstractComponentTest;
import org.apache.servicemix.camel.nmr.ServiceMixBinding;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.Pattern;
import org.junit.Test;

public class ServiceMixBindingTest
extends AbstractComponentTest {
    private static final String KEY = "test.key";
    private static final String VALUE = "test.value";
    private static final String MESSAGE = "Message content";
    private ServiceMixBinding binding = new ServiceMixBinding();

    @Test
    public void testToCamelAndBackToNmr() {
        Exchange nmr = this.getChannel().createExchange(Pattern.InOnly);
        nmr.setProperty(KEY, (Object)VALUE);
        nmr.getIn().setBody((Object)MESSAGE);
        nmr.getIn().setHeader(KEY, (Object)VALUE);
        org.apache.camel.Exchange camel = this.binding.populateCamelExchangeFromNmrExchange((CamelContext)new DefaultCamelContext(), nmr);
        ServiceMixBindingTest.assertEquals((Object)VALUE, (Object)camel.getProperty(KEY));
        ServiceMixBindingTest.assertEquals((Object)VALUE, (Object)camel.getIn().getHeader(KEY));
        ServiceMixBindingTest.assertEquals((Object)MESSAGE, (Object)camel.getIn().getBody());
        ServiceMixBindingTest.assertEquals((String)"NMR Exchange should be available on the Camel Exchange", (Object)nmr, (Object)camel.getProperty("nmrExchange"));
        ServiceMixBindingTest.assertSame((Object)nmr, (Object)this.binding.extractNmrExchange(camel));
        ServiceMixBindingTest.assertNull((String)"NMR Exchange should have been removed from the Camel Exchange", (Object)camel.getProperty("nmrExchange"));
    }
}

