/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr;

import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.servicemix.camel.nmr.AbstractComponentTest;
import org.apache.servicemix.nmr.api.Exchange;
import org.junit.Test;

public class SecuritySubjectTest
extends AbstractComponentTest {
    private static final String REQUEST_MESSAGE = "Simple message body";
    private static final String RESPONSE_MESSAGE = "Simple message reply";
    private static final Principal CLARK_KENT = new PrincipalImpl("Clark Kent");
    private static final Principal SUPERMAN = new PrincipalImpl("Superman");

    @Test
    public void testInOnlyWithSecuritySubject() throws Exception {
        Subject subject = this.createSubject(CLARK_KENT);
        MockEndpoint mock = this.getMockEndpoint("mock:simple");
        mock.expectedBodiesReceived(new Object[]{REQUEST_MESSAGE});
        template.sendBodyAndHeader("direct:simple", (Object)REQUEST_MESSAGE, "CamelAuthentication", (Object)subject);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInOutWithSecuritySubject() throws Exception {
        final Subject subject = this.createSubject(CLARK_KENT);
        org.apache.camel.Exchange result = template.request("direct:simple", new Processor(){

            public void process(org.apache.camel.Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)SecuritySubjectTest.REQUEST_MESSAGE);
                exchange.getIn().setHeader("CamelAuthentication", (Object)subject);
            }
        });
        this.assertSecuritySubject(SUPERMAN, (Subject)result.getOut().getHeader("CamelAuthentication", Subject.class));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:simple").to("nmr:simple");
                ((RouteDefinition)this.from("nmr:simple").process(SecuritySubjectTest.this.assertSecuritySubject())).to("mock:simple");
            }
        };
    }

    private Processor assertSecuritySubject() {
        return new Processor(){

            public void process(org.apache.camel.Exchange exchange) throws Exception {
                Subject subject = (Subject)exchange.getIn().getHeader("CamelAuthentication", Subject.class);
                SecuritySubjectTest.this.assertSecuritySubject(CLARK_KENT, subject);
                if (ExchangePattern.InOut.equals((Object)exchange.getPattern())) {
                    exchange.getOut().copyFrom(exchange.getIn());
                    exchange.getOut().setBody((Object)SecuritySubjectTest.RESPONSE_MESSAGE);
                    exchange.getOut().setHeader("CamelAuthentication", (Object)SecuritySubjectTest.this.createSubject(SUPERMAN));
                }
            }
        };
    }

    public void exchangeSent(Exchange exchange) {
        super.exchangeSent(exchange);
        if (exchange.getIn(false) != null) {
            this.assertSecuritySubject(CLARK_KENT, exchange.getIn().getSecuritySubject());
        }
        if (exchange.getOut(false) != null) {
            this.assertSecuritySubject(SUPERMAN, exchange.getOut().getSecuritySubject());
        }
    }

    private void assertSecuritySubject(Principal expected, Subject subject) {
        SecuritySubjectTest.assertNotNull((Object)subject);
        SecuritySubjectTest.assertTrue((String)("Subject should have contained " + expected), (boolean)subject.getPrincipals().contains(expected));
    }

    private Subject createSubject(Principal principal) {
        Subject subject = new Subject();
        subject.getPrincipals().add(principal);
        return subject;
    }

    private static final class PrincipalImpl
    implements Principal {
        private final String name;

        public PrincipalImpl(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return String.format("Principal [%s]", this.name);
        }
    }
}

