/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr;

import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.TryDefinition;
import org.apache.servicemix.camel.nmr.AbstractComponentTest;
import org.junit.Test;

public class CamelTryCatchTest
extends AbstractComponentTest {
    private static final String REQUEST_MESSAGE = "Simple message body";

    @Test
    public void testInOnlyTryCatch() throws InterruptedException {
        MockEndpoint mock = this.getMockEndpoint("mock:caught");
        mock.expectedMessageCount(1);
        template.sendBody("direct:inonly", (Object)REQUEST_MESSAGE);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testInOutTryCatch() throws InterruptedException {
        MockEndpoint mock = this.getMockEndpoint("mock:caught");
        mock.expectedMessageCount(1);
        template.requestBody("direct:inout", (Object)REQUEST_MESSAGE);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((TryDefinition)this.from("direct:inonly").doTry().to("nmr:throwsException")).doCatch(new Class[]{CustomBusinessException.class}).to("mock:caught");
                ((TryDefinition)this.from("direct:inout").doTry().to("nmr:throwsException")).doCatch(new Class[]{CustomBusinessException.class}).to("mock:caught");
                this.from("nmr:throwsException").errorHandler((ErrorHandlerBuilder)this.noErrorHandler()).throwException((Exception)new CustomBusinessException());
            }
        };
    }

    private static final class CustomBusinessException
    extends Exception {
        private CustomBusinessException() {
        }
    }
}

