/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr;

import java.util.LinkedList;
import java.util.List;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.test.junit4.CamelTestSupport;
import org.apache.servicemix.camel.nmr.ServiceMixComponent;
import org.apache.servicemix.camel.nmr.ServiceMixProducer;
import org.apache.servicemix.executors.ExecutorFactory;
import org.apache.servicemix.executors.impl.ExecutorConfig;
import org.apache.servicemix.executors.impl.ExecutorFactoryImpl;
import org.apache.servicemix.nmr.api.Channel;
import org.apache.servicemix.nmr.api.Endpoint;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.event.ExchangeListener;
import org.apache.servicemix.nmr.api.event.Listener;
import org.apache.servicemix.nmr.api.service.ServiceHelper;
import org.apache.servicemix.nmr.core.InternalEndpointWrapper;
import org.apache.servicemix.nmr.core.ServiceMix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComponentTest
extends CamelTestSupport
implements ExchangeListener {
    private ServiceMix nmr;
    private ServiceMixComponent component;
    private Channel channel;

    public void setUp() throws Exception {
        this.nmr = new ServiceMix();
        this.nmr.setExecutorFactory(this.createExecutorFactory());
        this.nmr.init();
        this.nmr.getListenerRegistry().register((Listener)this, ServiceHelper.createMap((String[])new String[0]));
        this.component = new ServiceMixComponent();
        this.component.setNmr((NMR)this.nmr);
        super.setUp();
    }

    public void tearDown() throws Exception {
        for (ServiceMixProducer producer : this.findEndpoints(ServiceMixProducer.class)) {
            if (producer.getContinuations().size() > 0) {
                Thread.sleep(500L);
            }
            AbstractComponentTest.assertEquals((String)"There should be no more pending Camel exchanges in the producer endpoints", (long)0L, (long)producer.getContinuations().size());
        }
        this.nmr.shutdown();
        super.tearDown();
    }

    private <E extends Endpoint> List<E> findEndpoints(Class<E> type) {
        LinkedList<E> result = new LinkedList<E>();
        for (Endpoint endpoint : this.nmr.getEndpointRegistry().getServices()) {
            InternalEndpointWrapper wrapper;
            if (!(endpoint instanceof InternalEndpointWrapper) || !type.isAssignableFrom((wrapper = (InternalEndpointWrapper)endpoint).getEndpoint().getClass())) continue;
            result.add(type.cast(wrapper.getEndpoint()));
        }
        return result;
    }

    protected ExecutorFactory createExecutorFactory() {
        ExecutorFactoryImpl factory = new ExecutorFactoryImpl();
        ExecutorConfig config = factory.getDefaultConfig();
        config.setCorePoolSize(Integer.valueOf(1));
        config.setMaximumPoolSize(Integer.valueOf(16));
        config.setQueueSize(Integer.valueOf(0));
        config.setBypassIfSynchronous(Boolean.valueOf(true));
        return factory;
    }

    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry registry = super.createRegistry();
        registry.bind("nmr", (Object)this.component);
        return registry;
    }

    protected Channel getChannel() {
        if (this.channel == null) {
            this.channel = this.nmr.createChannel();
        }
        return this.channel;
    }

    public void exchangeSent(Exchange exchange) {
    }

    public void exchangeDelivered(Exchange exchange) {
    }

    public void exchangeFailed(Exchange exchange) {
    }
}

