/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr;

import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.servicemix.camel.nmr.ServiceMixEndpoint;
import org.apache.servicemix.nmr.api.Channel;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.Pattern;
import org.apache.servicemix.nmr.api.Status;
import org.apache.servicemix.nmr.api.service.ServiceHelper;

public class ServiceMixProducer
extends DefaultProducer {
    private static final String OPERATION_NAME = "operationName";
    private Channel client;

    public ServiceMixProducer(ServiceMixEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public ServiceMixEndpoint getEndpoint() {
        return (ServiceMixEndpoint)super.getEndpoint();
    }

    public void process(org.apache.camel.Exchange exchange) throws Exception {
        NMR nmr = this.getEndpoint().getComponent().getNmr();
        Exchange e = this.getEndpoint().getComponent().getBinding().populateNmrExchangeFromCamelExchange(exchange, this.client);
        try {
            e.setTarget(nmr.getEndpointRegistry().lookup(ServiceHelper.createMap((String[])new String[]{"NAME", this.getEndpoint().getEndpointName()})));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.client.sendSync(e);
        this.handleResponse(exchange, this.client, e);
    }

    private void handleResponse(org.apache.camel.Exchange exchange, Channel client, Exchange e) {
        if (e.getPattern() != Pattern.InOnly) {
            if (e.getError() != null) {
                exchange.setException(e.getError());
            } else {
                exchange.getProperties().putAll(e.getProperties());
                if (e.getFault().getBody() != null) {
                    exchange.getOut().setFault(true);
                    this.getEndpoint().getComponent().getBinding().copyNmrMessageToCamelMessage(e.getFault(), exchange.getOut());
                } else {
                    this.getEndpoint().getComponent().getBinding().copyNmrMessageToCamelMessage(e.getOut(), exchange.getOut());
                }
                e.setStatus(Status.Done);
                client.send(e);
            }
        }
    }

    protected void doStart() throws Exception {
        NMR nmr = this.getEndpoint().getComponent().getNmr();
        this.client = nmr.createChannel();
    }

    protected void doStop() throws Exception {
        this.client.close();
        this.client = null;
    }
}

