/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel.nmr;

import java.util.Map;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.servicemix.camel.nmr.ServiceMixEndpoint;
import org.apache.servicemix.nmr.api.Channel;
import org.apache.servicemix.nmr.api.Endpoint;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.Status;
import org.apache.servicemix.nmr.api.service.ServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceMixConsumer
extends DefaultConsumer
implements Endpoint {
    private Channel channel;

    public ServiceMixConsumer(ServiceMixEndpoint endpoint, Processor processor) {
        super((org.apache.camel.Endpoint)endpoint, processor);
    }

    public ServiceMixEndpoint getEndpoint() {
        return (ServiceMixEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.getEndpoint().getComponent().registerEndpoint(this, this.createEndpointMap());
    }

    protected void doStop() throws Exception {
        this.getEndpoint().getComponent().unregisterEndpoint(this, this.createEndpointMap());
        super.doStop();
    }

    private Map<String, ?> createEndpointMap() {
        return ServiceHelper.createMap((String[])new String[]{"NAME", this.getEndpoint().getEndpointName()});
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void process(Exchange exchange) {
        if (exchange.getStatus() == Status.Active) {
            try {
                org.apache.camel.Exchange camelExchange = this.getEndpoint().createExchange(exchange);
                this.getProcessor().process(camelExchange);
                exchange.getProperties().putAll(camelExchange.getProperties());
                if (camelExchange.hasOut() && !camelExchange.getOut().isFault()) {
                    this.getEndpoint().getComponent().getBinding().copyCamelMessageToNmrMessage(exchange.getOut(), camelExchange.getOut());
                } else if (camelExchange.hasOut() && camelExchange.getOut().isFault()) {
                    this.getEndpoint().getComponent().getBinding().copyCamelMessageToNmrMessage(exchange.getFault(), camelExchange.getOut());
                } else {
                    if (camelExchange.getException() != null) {
                        throw camelExchange.getException();
                    }
                    exchange.setStatus(Status.Done);
                }
                this.channel.send(exchange);
            }
            catch (Exception e) {
                exchange.setError(e);
                exchange.setStatus(Status.Error);
                this.channel.send(exchange);
            }
        }
    }
}

