/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.springmvc.processor.annotation;

import io.swagger.models.parameters.CookieParameter;
import java.lang.reflect.Type;
import org.apache.servicecomb.swagger.generator.core.model.HttpParameterType;
import org.apache.servicecomb.swagger.generator.springmvc.processor.annotation.AbstractSpringmvcSerializableParameterProcessor;
import org.springframework.web.bind.annotation.CookieValue;

public class CookieValueAnnotationProcessor
extends AbstractSpringmvcSerializableParameterProcessor<CookieParameter, CookieValue> {
    public Type getProcessType() {
        return CookieValue.class;
    }

    public String getParameterName(CookieValue annotation) {
        String value = annotation.value();
        if (value.isEmpty()) {
            value = annotation.name();
        }
        return value;
    }

    public HttpParameterType getHttpParameterType(CookieValue parameterAnnotation) {
        return HttpParameterType.COOKIE;
    }

    @Override
    protected boolean readRequired(CookieValue cookieValue) {
        return cookieValue.required();
    }

    @Override
    protected String pureReadDefaultValue(CookieValue cookieValue) {
        return cookieValue.defaultValue();
    }
}

