/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.format;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.servicecomb.saga.core.Compensation;
import org.apache.servicecomb.saga.core.Fallback;
import org.apache.servicecomb.saga.core.Operation;
import org.apache.servicecomb.saga.core.SagaRequestImpl;
import org.apache.servicecomb.saga.core.Transaction;
import org.apache.servicecomb.saga.format.JacksonFallback;
import org.apache.servicecomb.saga.format.JacksonSQLCompensation;
import org.apache.servicecomb.saga.format.JacksonSQLTransaction;
import org.apache.servicecomb.saga.format.JsonSagaRequest;
import org.apache.servicecomb.saga.transports.SQLTransport;
import org.apache.servicecomb.saga.transports.TransportFactory;

public class JsonSQLSagaRequest
extends SagaRequestImpl
implements JsonSagaRequest<SQLTransport> {
    private JacksonSQLTransaction transaction;
    private JacksonSQLCompensation compensation;

    @JsonCreator
    public JsonSQLSagaRequest(@JsonProperty(value="id") String id, @JsonProperty(value="datasource") String datasource, @JsonProperty(value="type") String type, @JsonProperty(value="transaction") JacksonSQLTransaction transaction, @JsonProperty(value="compensation") JacksonSQLCompensation compensation, @JsonProperty(value="fallback") Fallback fallback, @JsonProperty(value="parents") String[] parents, @JsonProperty(value="failRetryDelayMilliseconds") int failRetryDelayMilliseconds) {
        super(id, datasource, type, (Transaction)transaction, (Compensation)compensation, (Fallback)(fallback == null ? JacksonFallback.NOP_TRANSPORT_AWARE_FALLBACK : fallback), parents, failRetryDelayMilliseconds);
        this.checkNull((Operation)transaction, "transaction");
        this.checkNull((Operation)compensation, "compensation");
        this.transaction = transaction;
        this.compensation = compensation;
    }

    @Override
    public JsonSagaRequest with(TransportFactory transportFactory) {
        this.transaction.with((TransportFactory<SQLTransport>)transportFactory);
        this.compensation.with((TransportFactory<SQLTransport>)transportFactory);
        return this;
    }

    private void checkNull(Operation operation, String operationName) {
        if (operation == null) {
            throw new IllegalArgumentException("Invalid request with NO " + operationName + " specified");
        }
    }
}

