/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.format;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import kamon.annotation.EnableKamon;
import kamon.annotation.Segment;
import org.apache.servicecomb.saga.core.SagaDefinition;
import org.apache.servicecomb.saga.core.SagaException;
import org.apache.servicecomb.saga.core.application.interpreter.FromJsonFormat;
import org.apache.servicecomb.saga.format.JsonSagaDefinition;
import org.apache.servicecomb.saga.format.JsonSagaRequest;
import org.apache.servicecomb.saga.transports.TransportFactory;

@EnableKamon
public class JacksonFromJsonFormat
implements FromJsonFormat<SagaDefinition> {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final TransportFactory transportFactory;

    public JacksonFromJsonFormat(TransportFactory transportFactory) {
        this.transportFactory = transportFactory;
    }

    @Segment(name="fromJson", category="application", library="kamon")
    public SagaDefinition fromJson(String requestJson) {
        try {
            JsonSagaDefinition definition = (JsonSagaDefinition)this.objectMapper.readValue(requestJson, JsonSagaDefinition.class);
            for (JsonSagaRequest request : definition.requests()) {
                request.with(this.transportFactory);
            }
            return definition;
        }
        catch (IOException e) {
            throw new SagaException("Failed to interpret JSON " + requestJson, (Throwable)e);
        }
    }
}

