/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.format;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.servicecomb.saga.core.SagaException;
import org.apache.servicecomb.saga.core.application.interpreter.FromJsonFormat;

public class ChildrenExtractor
implements FromJsonFormat<Set<String>> {
    private static final String SAGA_CHILDREN = "sagaChildren";
    private final ObjectMapper objectMapper = new ObjectMapper();

    public Set<String> fromJson(String json) {
        try {
            return this.childrenOf((ObjectNode)this.objectMapper.readValue(json, ObjectNode.class));
        }
        catch (IOException e) {
            throw new SagaException("Failed to deserialize json " + json, (Throwable)e);
        }
    }

    private Set<String> childrenOf(ObjectNode value) {
        HashSet<String> children = new HashSet<String>();
        if (value.has(SAGA_CHILDREN)) {
            for (JsonNode node : value.get(SAGA_CHILDREN)) {
                children.add(node.textValue());
            }
        }
        return children;
    }
}

