/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.omega.transport.servicecomb;

import io.servicecomb.core.Handler;
import io.servicecomb.core.Invocation;
import io.servicecomb.swagger.invocation.AsyncResponse;
import java.lang.invoke.MethodHandles;
import org.apache.servicecomb.saga.omega.context.OmegaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SagaProviderHandler
implements Handler {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OmegaContext omegaContext;

    @Autowired
    public SagaProviderHandler(OmegaContext omegaContext) {
        this.omegaContext = omegaContext;
    }

    public void handle(Invocation invocation, AsyncResponse asyncResponse) throws Exception {
        String globalTxId = (String)invocation.getContext().get("X-Pack-Global-Transaction-Id");
        if (globalTxId == null) {
            LOG.debug("no such header: {}", (Object)"X-Pack-Global-Transaction-Id");
        } else {
            this.omegaContext.setGlobalTxId(globalTxId);
            this.omegaContext.setLocalTxId((String)invocation.getContext().get("X-Pack-Local-Transaction-Id"));
        }
        invocation.next(asyncResponse);
    }
}

