/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.omega.transport.servicecomb;

import io.servicecomb.core.Handler;
import io.servicecomb.core.Invocation;
import io.servicecomb.swagger.invocation.AsyncResponse;
import java.lang.invoke.MethodHandles;
import org.apache.servicecomb.saga.omega.context.OmegaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SagaConsumerHandler
implements Handler {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OmegaContext omegaContext;

    @Autowired
    public SagaConsumerHandler(OmegaContext omegaContext) {
        this.omegaContext = omegaContext;
    }

    public void handle(Invocation invocation, AsyncResponse asyncResponse) throws Exception {
        if (this.omegaContext.globalTxId() != null) {
            invocation.getContext().put("X-Pack-Global-Transaction-Id", this.omegaContext.globalTxId());
            invocation.getContext().put("X-Pack-Local-Transaction-Id", this.omegaContext.localTxId());
            LOG.debug("Added {} {} and {} {} to request header", new Object[]{"X-Pack-Global-Transaction-Id", this.omegaContext.globalTxId(), "X-Pack-Local-Transaction-Id", this.omegaContext.localTxId()});
        }
        invocation.next(asyncResponse);
    }
}

