/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.omega.transaction.spring;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.servicecomb.saga.omega.context.OmegaContext;
import org.apache.servicecomb.saga.omega.transaction.spring.annotations.OmegaContextAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

class ExecutorFieldCallback
implements ReflectionUtils.FieldCallback {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OmegaContext omegaContext;
    private final Object bean;

    ExecutorFieldCallback(Object bean, OmegaContext omegaContext) {
        this.omegaContext = omegaContext;
        this.bean = bean;
    }

    public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
        if (!field.isAnnotationPresent(OmegaContextAware.class)) {
            return;
        }
        ReflectionUtils.makeAccessible((Field)field);
        Class<?> generic = field.getType();
        if (!Executor.class.isAssignableFrom(generic)) {
            throw new IllegalArgumentException("Only Executor, ExecutorService, and ScheduledExecutorService are supported for @" + OmegaContextAware.class.getSimpleName());
        }
        field.set(this.bean, ExecutorProxy.newInstance(field.get(this.bean), field.getType(), this.omegaContext));
    }

    private static class ExecutorProxy
    implements InvocationHandler {
        private final Object target;
        private final OmegaContext omegaContext;

        private ExecutorProxy(Object target, OmegaContext omegaContext) {
            this.target = target;
            this.omegaContext = omegaContext;
        }

        private static Object newInstance(Object target, Class<?> targetClass, OmegaContext omegaContext) {
            Class<?>[] classArray;
            if (targetClass.isInterface()) {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = targetClass;
            } else {
                classArray = targetClass.getInterfaces();
            }
            Class<?>[] interfaces = classArray;
            return Proxy.newProxyInstance(targetClass.getClassLoader(), interfaces, (InvocationHandler)new ExecutorProxy(target, omegaContext));
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke(this.target, this.augmentRunnablesWithOmegaContext(args));
        }

        private Object[] augmentRunnablesWithOmegaContext(Object[] args) {
            Object[] augmentedArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                augmentedArgs[i] = this.isExecutable(arg) ? RunnableProxy.newInstance(arg, this.omegaContext) : (this.isCollectionOfExecutables(arg) ? ((Collection)arg).stream().map(a -> RunnableProxy.newInstance(a, this.omegaContext)).collect(Collectors.toList()) : arg);
            }
            return augmentedArgs;
        }

        private boolean isExecutable(Object arg) {
            return arg instanceof Runnable || arg instanceof Callable;
        }

        private boolean isCollectionOfExecutables(Object arg) {
            return arg instanceof Collection && !((Collection)arg).isEmpty() && this.isExecutable(((Collection)arg).iterator().next());
        }
    }

    private static class RunnableProxy
    implements InvocationHandler {
        private final String globalTxId;
        private final String localTxId;
        private final Object runnable;
        private final OmegaContext omegaContext;

        private static Object newInstance(Object runnable, OmegaContext omegaContext) {
            RunnableProxy runnableProxy = new RunnableProxy(omegaContext, runnable);
            return Proxy.newProxyInstance(runnable.getClass().getClassLoader(), runnable.getClass().getInterfaces(), (InvocationHandler)runnableProxy);
        }

        private RunnableProxy(OmegaContext omegaContext, Object runnable) {
            this.omegaContext = omegaContext;
            this.globalTxId = omegaContext.globalTxId();
            this.localTxId = omegaContext.localTxId();
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                LOG.debug("Setting OmegaContext with globalTxId [{}] & localTxId [{}]", (Object)this.globalTxId, (Object)this.localTxId);
                this.omegaContext.setGlobalTxId(this.globalTxId);
                this.omegaContext.setLocalTxId(this.localTxId);
                Object object = method.invoke(this.runnable, args);
                return object;
            }
            finally {
                this.omegaContext.clear();
                LOG.debug("Cleared OmegaContext with globalTxId [{}] & localTxId [{}]", (Object)this.globalTxId, (Object)this.localTxId);
            }
        }
    }
}

