/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.omega.transaction.spring;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.servicecomb.saga.omega.context.CompensationContext;
import org.apache.servicecomb.saga.omega.transaction.OmegaException;
import org.apache.servicecomb.saga.omega.transaction.annotations.Compensable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.ReflectionUtils;

class CompensableMethodCheckingCallback
implements ReflectionUtils.MethodCallback {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Object bean;
    private final CompensationContext compensationContext;

    CompensableMethodCheckingCallback(Object bean, CompensationContext compensationContext) {
        this.bean = bean;
        this.compensationContext = compensationContext;
    }

    public void doWith(Method method) throws IllegalArgumentException {
        if (!method.isAnnotationPresent(Compensable.class)) {
            return;
        }
        String compensationMethod = method.getAnnotation(Compensable.class).compensationMethod();
        try {
            if (!compensationMethod.isEmpty()) {
                Method signature = this.bean.getClass().getDeclaredMethod(compensationMethod, method.getParameterTypes());
                String key = this.getTargetBean(this.bean).getClass().getDeclaredMethod(compensationMethod, method.getParameterTypes()).toString();
                this.compensationContext.addCompensationContext(key, signature, this.bean);
                LOG.debug("Found compensation method [{}] in {}", (Object)compensationMethod, (Object)this.bean.getClass().getCanonicalName());
            }
        }
        catch (Exception e) {
            throw new OmegaException("No such compensation method [" + compensationMethod + "] found in " + this.bean.getClass().getCanonicalName(), (Throwable)e);
        }
    }

    private Object getTargetBean(Object proxy) throws Exception {
        if (!AopUtils.isAopProxy((Object)proxy)) {
            return proxy;
        }
        if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
            return this.getJdkDynamicProxyTargetObject(proxy);
        }
        return this.getCglibProxyTargetObject(proxy);
    }

    private Object getCglibProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        h.setAccessible(true);
        Object dynamicAdvisedInterceptor = h.get(proxy);
        Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object result = ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
        return result;
    }

    private Object getJdkDynamicProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
        h.setAccessible(true);
        AopProxy aopProxy = (AopProxy)h.get(proxy);
        Field advised = aopProxy.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object result = ((AdvisedSupport)advised.get(aopProxy)).getTargetSource().getTarget();
        return result;
    }
}

