/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.omega.spring;

import java.util.Arrays;
import org.apache.servicecomb.saga.omega.connector.grpc.AlphaClusterConfig;
import org.apache.servicecomb.saga.omega.connector.grpc.LoadBalancedClusterMessageSender;
import org.apache.servicecomb.saga.omega.context.CompensationContext;
import org.apache.servicecomb.saga.omega.context.IdGenerator;
import org.apache.servicecomb.saga.omega.context.OmegaContext;
import org.apache.servicecomb.saga.omega.context.ServiceConfig;
import org.apache.servicecomb.saga.omega.context.UniqueIdGenerator;
import org.apache.servicecomb.saga.omega.format.KryoMessageFormat;
import org.apache.servicecomb.saga.omega.transaction.MessageDeserializer;
import org.apache.servicecomb.saga.omega.transaction.MessageHandler;
import org.apache.servicecomb.saga.omega.transaction.MessageSender;
import org.apache.servicecomb.saga.omega.transaction.MessageSerializer;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
class OmegaSpringConfig {
    OmegaSpringConfig() {
    }

    @Bean(name={"omegaUniqueIdGenerator"})
    IdGenerator<String> idGenerator() {
        return new UniqueIdGenerator();
    }

    @Bean
    OmegaContext omegaContext(@Qualifier(value="omegaUniqueIdGenerator") IdGenerator<String> idGenerator) {
        return new OmegaContext(idGenerator);
    }

    @Bean
    CompensationContext compensationContext(OmegaContext omegaContext) {
        return new CompensationContext(omegaContext);
    }

    @Bean
    ServiceConfig serviceConfig(@Value(value="${spring.application.name}") String serviceName) {
        return new ServiceConfig(serviceName);
    }

    @Bean
    MessageSender grpcMessageSender(@Value(value="${alpha.cluster.address:localhost:8080}") String[] addresses, @Value(value="${alpha.cluster.ssl.enable:false}") boolean enableSSL, @Value(value="${alpha.cluster.ssl.mutualAuth:false}") boolean mutualAuth, @Value(value="${alpha.cluster.ssl.cert:client.crt}") String cert, @Value(value="${alpha.cluster.ssl.key:client.pem}") String key, @Value(value="${alpha.cluster.ssl.certChain:ca.crt}") String certChain, @Value(value="${omega.connection.reconnectDelay:3000}") int reconnectDelay, ServiceConfig serviceConfig, @Lazy MessageHandler handler) {
        KryoMessageFormat messageFormat = new KryoMessageFormat();
        AlphaClusterConfig clusterConfig = new AlphaClusterConfig(Arrays.asList(addresses), enableSSL, mutualAuth, cert, key, certChain);
        LoadBalancedClusterMessageSender sender = new LoadBalancedClusterMessageSender(clusterConfig, (MessageSerializer)messageFormat, (MessageDeserializer)messageFormat, serviceConfig, handler, reconnectDelay);
        sender.onConnected();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> OmegaSpringConfig.lambda$grpcMessageSender$0((MessageSender)sender)));
        return sender;
    }

    private static /* synthetic */ void lambda$grpcMessageSender$0(MessageSender sender) {
        sender.onDisconnected();
        sender.close();
    }
}

