/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.omega.spring;

import org.apache.servicecomb.saga.omega.connector.grpc.LoadBalancedClusterMessageSender;
import org.apache.servicecomb.saga.omega.context.CompensationContext;
import org.apache.servicecomb.saga.omega.context.IdGenerator;
import org.apache.servicecomb.saga.omega.context.OmegaContext;
import org.apache.servicecomb.saga.omega.context.ServiceConfig;
import org.apache.servicecomb.saga.omega.context.UniqueIdGenerator;
import org.apache.servicecomb.saga.omega.format.KryoMessageFormat;
import org.apache.servicecomb.saga.omega.transaction.MessageDeserializer;
import org.apache.servicecomb.saga.omega.transaction.MessageHandler;
import org.apache.servicecomb.saga.omega.transaction.MessageSender;
import org.apache.servicecomb.saga.omega.transaction.MessageSerializer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
class OmegaSpringConfig {
    OmegaSpringConfig() {
    }

    @Bean
    IdGenerator<String> idGenerator() {
        return new UniqueIdGenerator();
    }

    @Bean
    OmegaContext omegaContext(IdGenerator<String> idGenerator) {
        return new OmegaContext(idGenerator);
    }

    @Bean
    CompensationContext compensationContext() {
        return new CompensationContext();
    }

    @Bean
    ServiceConfig serviceConfig(@Value(value="${spring.application.name}") String serviceName) {
        return new ServiceConfig(serviceName);
    }

    @Bean
    MessageSender grpcMessageSender(@Value(value="${alpha.cluster.address}") String[] addresses, @Value(value="${omega.connection.reconnectDelay:3000}") int reconnectDelay, ServiceConfig serviceConfig, @Lazy MessageHandler handler) {
        KryoMessageFormat messageFormat = new KryoMessageFormat();
        LoadBalancedClusterMessageSender sender = new LoadBalancedClusterMessageSender(addresses, (MessageSerializer)messageFormat, (MessageDeserializer)messageFormat, serviceConfig, handler, reconnectDelay);
        sender.onConnected();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> OmegaSpringConfig.lambda$grpcMessageSender$0((MessageSender)sender)));
        return sender;
    }

    private static /* synthetic */ void lambda$grpcMessageSender$0(MessageSender sender) {
        sender.onDisconnected();
        sender.close();
    }
}

