/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.omega.context;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompensationContext {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, CompensationContextInternal> contexts = new ConcurrentHashMap<String, CompensationContextInternal>();

    public void addCompensationContext(Method compensationMethod, Object target) {
        compensationMethod.setAccessible(true);
        this.contexts.put(compensationMethod.toString(), new CompensationContextInternal(target, compensationMethod));
    }

    public void apply(String globalTxId, String localTxId, String compensationMethod, Object ... payloads) {
        CompensationContextInternal contextInternal = this.contexts.get(compensationMethod);
        try {
            contextInternal.compensationMethod.invoke(contextInternal.target, payloads);
            LOG.info("Compensated transaction with global tx id [{}], local tx id [{}]", (Object)globalTxId, (Object)localTxId);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.error("Pre-checking for compensation method " + contextInternal.compensationMethod.toString() + " was somehow skipped, did you forget to configure compensable method checking on service startup?", (Throwable)e);
        }
    }

    private static final class CompensationContextInternal {
        private final Object target;
        private final Method compensationMethod;

        private CompensationContextInternal(Object target, Method compensationMethod) {
            this.target = target;
            this.compensationMethod = compensationMethod;
        }
    }
}

