/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.omega.context;

import org.apache.servicecomb.saga.omega.context.IdGenerator;

public class OmegaContext {
    public static final String GLOBAL_TX_ID_KEY = "X-Pack-Global-Transaction-Id";
    public static final String LOCAL_TX_ID_KEY = "X-Pack-Local-Transaction-Id";
    private final ThreadLocal<String> globalTxId = new InheritableThreadLocal<String>();
    private final ThreadLocal<String> localTxId = new InheritableThreadLocal<String>();
    private final IdGenerator<String> idGenerator;

    public OmegaContext(IdGenerator<String> idGenerator) {
        this.idGenerator = idGenerator;
    }

    public String newGlobalTxId() {
        String id = this.idGenerator.nextId();
        this.globalTxId.set(id);
        return id;
    }

    public void setGlobalTxId(String txId) {
        this.globalTxId.set(txId);
    }

    public String globalTxId() {
        return this.globalTxId.get();
    }

    public String newLocalTxId() {
        String id = this.idGenerator.nextId();
        this.localTxId.set(id);
        return id;
    }

    public void setLocalTxId(String localTxId) {
        this.localTxId.set(localTxId);
    }

    public String localTxId() {
        return this.localTxId.get();
    }

    public void clear() {
        this.globalTxId.remove();
        this.localTxId.remove();
    }

    public String toString() {
        return "OmegaContext{globalTxId=" + this.globalTxId.get() + ", localTxId=" + this.localTxId.get() + '}';
    }
}

