/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.omega.connector.grpc;

import java.util.concurrent.BlockingQueue;
import org.apache.servicecomb.saga.common.EventType;
import org.apache.servicecomb.saga.omega.transaction.AlphaResponse;
import org.apache.servicecomb.saga.omega.transaction.MessageSender;
import org.apache.servicecomb.saga.omega.transaction.OmegaException;
import org.apache.servicecomb.saga.omega.transaction.TxEvent;

public class RetryableMessageSender
implements MessageSender {
    private final BlockingQueue<MessageSender> availableMessageSenders;

    public RetryableMessageSender(BlockingQueue<MessageSender> availableMessageSenders) {
        this.availableMessageSenders = availableMessageSenders;
    }

    public AlphaResponse send(TxEvent event) {
        if (event.type() == EventType.SagaStartedEvent) {
            throw new OmegaException("Failed to process subsequent requests because no alpha server is available");
        }
        try {
            return this.availableMessageSenders.take().send(event);
        }
        catch (InterruptedException e) {
            throw new OmegaException("Failed to send event " + event + " due to interruption", (Throwable)e);
        }
    }
}

