/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.omega.connector.grpc;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.apache.servicecomb.saga.omega.transaction.MessageSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PushBackReconnectRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final MessageSender messageSender;
    private final Map<MessageSender, Long> senders;
    private final BlockingQueue<Runnable> pendingTasks;
    private final BlockingQueue<MessageSender> connectedSenders;

    PushBackReconnectRunnable(MessageSender messageSender, Map<MessageSender, Long> senders, BlockingQueue<Runnable> pendingTasks, BlockingQueue<MessageSender> connectedSenders) {
        this.messageSender = messageSender;
        this.senders = senders;
        this.pendingTasks = pendingTasks;
        this.connectedSenders = connectedSenders;
    }

    @Override
    public void run() {
        try {
            log.info("Retry connecting to alpha at {}", (Object)this.messageSender.target());
            this.messageSender.onDisconnected();
            this.messageSender.onConnected();
            this.senders.put(this.messageSender, 0L);
            this.connectedSenders.offer(this.messageSender);
            log.info("Retry connecting to alpha at {} is successful", (Object)this.messageSender.target());
        }
        catch (Exception e) {
            log.error("Failed to reconnect to alpha at {}", (Object)this.messageSender.target(), (Object)e);
            this.pendingTasks.offer(this);
        }
    }
}

