/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.alpha.server;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.servicecomb.saga.alpha.core.Command;
import org.apache.servicecomb.saga.alpha.core.CommandRepository;
import org.apache.servicecomb.saga.alpha.core.TaskStatus;
import org.apache.servicecomb.saga.alpha.core.TxEvent;
import org.apache.servicecomb.saga.alpha.server.CommandEntityRepository;
import org.apache.servicecomb.saga.alpha.server.TxEventEnvelopeRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringCommandRepository
implements CommandRepository {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final TxEventEnvelopeRepository eventRepository;
    private final CommandEntityRepository commandRepository;

    SpringCommandRepository(TxEventEnvelopeRepository eventRepository, CommandEntityRepository commandRepository) {
        this.eventRepository = eventRepository;
        this.commandRepository = commandRepository;
    }

    public void saveCompensationCommands(String globalTxId) {
        List events = this.eventRepository.findStartedEventsWithMatchingEndedButNotCompensatedEvents(globalTxId);
        LinkedHashMap<String, Command> commands = new LinkedHashMap<String, Command>();
        for (TxEvent event : events) {
            commands.computeIfAbsent(event.localTxId(), k -> new Command(event));
        }
        for (Command command : commands.values()) {
            LOG.info("Saving compensation command {}", (Object)command);
            try {
                this.commandRepository.save((Object)command);
            }
            catch (Exception e) {
                LOG.warn("Failed to save some command {}", (Object)command);
            }
            LOG.info("Saved compensation command {}", (Object)command);
        }
    }

    public void markCommandAsDone(String globalTxId, String localTxId) {
        this.commandRepository.updateStatusByGlobalTxIdAndLocalTxId(TaskStatus.DONE.name(), globalTxId, localTxId);
    }

    public List<Command> findUncompletedCommands(String globalTxId) {
        return this.commandRepository.findByGlobalTxIdAndStatus(globalTxId, TaskStatus.NEW.name());
    }

    @Transactional
    public List<Command> findFirstCommandToCompensate() {
        List commands = this.commandRepository.findFirstGroupByGlobalTxIdWithoutPendingOrderByIdDesc();
        commands.forEach(command -> this.commandRepository.updateStatusByGlobalTxIdAndLocalTxId(TaskStatus.NEW.name(), TaskStatus.PENDING.name(), command.globalTxId(), command.localTxId()));
        return commands;
    }
}

