/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.alpha.server;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyServerBuilder;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Properties;
import javax.net.ssl.SSLException;
import org.apache.servicecomb.saga.alpha.server.GrpcServerConfig;
import org.apache.servicecomb.saga.alpha.server.ServerStartable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcStartable
implements ServerStartable {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Server server;

    GrpcStartable(GrpcServerConfig serverConfig, BindableService ... services) {
        ServerBuilder serverBuilder;
        if (serverConfig.isSslEnable()) {
            serverBuilder = NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(serverConfig.getHost(), serverConfig.getPort()));
            try {
                ((NettyServerBuilder)serverBuilder).sslContext(this.getSslContextBuilder(serverConfig).build());
            }
            catch (SSLException e) {
                throw new IllegalStateException("Unable to setup grpc to use SSL.", e);
            }
        } else {
            serverBuilder = ServerBuilder.forPort((int)serverConfig.getPort());
        }
        Arrays.stream(services).forEach(arg_0 -> ((ServerBuilder)serverBuilder).addService(arg_0));
        this.server = serverBuilder.build();
    }

    public void start() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((Server)this.server).shutdown()));
        try {
            this.server.start();
            this.server.awaitTermination();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to start grpc server.", e);
        }
        catch (InterruptedException e) {
            LOG.error("grpc server was interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private SslContextBuilder getSslContextBuilder(GrpcServerConfig config) {
        Properties prop = new Properties();
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            prop.load(classLoader.getResourceAsStream("ssl.properties"));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read ssl.properties.", e);
        }
        InputStream cert = this.getInputStream(classLoader, config.getCert(), "Server Cert");
        InputStream key = this.getInputStream(classLoader, config.getKey(), "Server Key");
        SslContextBuilder sslClientContextBuilder = SslContextBuilder.forServer((InputStream)cert, (InputStream)key).protocols(new String[]{prop.getProperty("protocols")}).ciphers(Arrays.asList(prop.getProperty("ciphers").split(",")));
        if (config.isMutualAuth()) {
            InputStream clientCert = this.getInputStream(classLoader, config.getClientCert(), "Client Cert");
            sslClientContextBuilder.trustManager(clientCert);
            sslClientContextBuilder.clientAuth(ClientAuth.REQUIRE);
        }
        return GrpcSslContexts.configure((SslContextBuilder)sslClientContextBuilder, (SslProvider)SslProvider.OPENSSL);
    }

    private InputStream getInputStream(ClassLoader classLoader, String resource, String config) {
        InputStream is = classLoader.getResourceAsStream(resource);
        if (is == null) {
            throw new IllegalStateException("Cannot load the " + config + " from " + resource);
        }
        return is;
    }
}

