/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.alpha.server;

import java.util.List;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.servicecomb.saga.alpha.core.TxEvent;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;

interface TxEventEnvelopeRepository
extends CrudRepository<TxEvent, Long> {
    public List<TxEvent> findByGlobalTxId(String var1);

    @Query(value="SELECT t FROM TxEvent t WHERE t.type = 'TxAbortedEvent' AND NOT EXISTS(   SELECT t1.globalTxId FROM TxEvent t1  WHERE t1.globalTxId = t.globalTxId     AND t1.type IN ('TxEndedEvent', 'SagaEndedEvent'))")
    public Optional<TxEvent> findFirstAbortedGlobalTxByType();

    @Query(value="SELECT t FROM TxEvent t WHERE t.type IN ('TxStartedEvent', 'SagaStartedEvent')   AND t.expiryTime < CURRENT_TIMESTAMP AND NOT EXISTS(   SELECT t1.globalTxId FROM TxEvent t1   WHERE t1.globalTxId = t.globalTxId     AND t1.localTxId = t.localTxId     AND t1.type != t.type)")
    public List<TxEvent> findTimeoutEvents(Pageable var1);

    @Query(value="SELECT t FROM TxEvent t WHERE t.globalTxId = ?1   AND t.localTxId = ?2   AND t.type = 'TxStartedEvent'")
    public Optional<TxEvent> findFirstStartedEventByGlobalTxIdAndLocalTxId(String var1, String var2);

    @Query(value="SELECT DISTINCT new org.apache.servicecomb.saga.alpha.core.TxEvent(t.serviceName, t.instanceId, t.globalTxId, t.localTxId, t.parentTxId, t.type, t.compensationMethod, t.payloads) FROM TxEvent t WHERE t.globalTxId = ?1 AND t.type = ?2")
    public List<TxEvent> findByEventGlobalTxIdAndEventType(String var1, String var2);

    @Query(value="SELECT t FROM TxEvent t WHERE t.globalTxId = ?1 AND t.type = 'TxStartedEvent' AND EXISTS (   SELECT t1.globalTxId  FROM TxEvent t1   WHERE t1.globalTxId = ?1   AND t1.localTxId = t.localTxId   AND t1.type = 'TxEndedEvent') AND NOT EXISTS (   SELECT t2.globalTxId  FROM TxEvent t2   WHERE t2.globalTxId = ?1   AND t2.localTxId = t.localTxId   AND t2.type = 'TxCompensatedEvent') ORDER BY t.surrogateId ASC")
    public List<TxEvent> findStartedEventsWithMatchingEndedButNotCompensatedEvents(String var1);

    @Query(value="SELECT t FROM TxEvent t WHERE t.type = ?1 AND t.surrogateId > ?2 AND EXISTS (   SELECT t1.globalTxId  FROM TxEvent t1   WHERE t1.globalTxId = t.globalTxId   AND t1.type = 'TxAbortedEvent') AND NOT EXISTS (   SELECT t2.globalTxId  FROM TxEvent t2   WHERE t2.globalTxId = t.globalTxId   AND t2.localTxId = t.localTxId   AND t2.type = 'TxCompensatedEvent') ORDER BY t.surrogateId ASC")
    public List<TxEvent> findFirstByTypeAndSurrogateIdGreaterThan(String var1, long var2, Pageable var4);

    public Optional<TxEvent> findFirstByTypeAndSurrogateIdGreaterThan(String var1, long var2);

    @Transactional
    @Modifying(clearAutomatically=true)
    @Query(value="DELETE FROM TxEvent t WHERE t.type = ?1 AND t.surrogateId NOT IN ( SELECT MAX(t1.surrogateId) FROM TxEvent t1  WHERE t1.type = ?1  GROUP BY t1.globalTxId)")
    public void deleteByType(String var1);
}

