/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.alpha.server;

import java.lang.invoke.MethodHandles;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.servicecomb.saga.alpha.core.TaskStatus;
import org.apache.servicecomb.saga.alpha.core.TxTimeout;
import org.apache.servicecomb.saga.alpha.core.TxTimeoutRepository;
import org.apache.servicecomb.saga.alpha.server.TxTimeoutEntityRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class SpringTxTimeoutRepository
implements TxTimeoutRepository {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final TxTimeoutEntityRepository timeoutRepo;

    SpringTxTimeoutRepository(TxTimeoutEntityRepository timeoutRepo) {
        this.timeoutRepo = timeoutRepo;
    }

    public void save(TxTimeout timeout) {
        try {
            this.timeoutRepo.save((Object)timeout);
        }
        catch (Exception ignored) {
            log.warn("Failed to save some timeout {}", (Object)timeout);
        }
    }

    public void markTimeoutAsDone() {
        this.timeoutRepo.updateStatusOfFinishedTx();
    }

    @Transactional
    public List<TxTimeout> findFirstTimeout() {
        List timeoutEvents = this.timeoutRepo.findFirstTimeoutTxOrderByExpireTimeAsc((Pageable)new PageRequest(0, 1));
        timeoutEvents.forEach(event -> this.timeoutRepo.updateStatusByGlobalTxIdAndLocalTxId(TaskStatus.PENDING.name(), event.globalTxId(), event.localTxId()));
        return timeoutEvents;
    }
}

