/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.alpha.server;

import java.util.List;
import java.util.Optional;
import org.apache.servicecomb.saga.alpha.core.TxEvent;
import org.apache.servicecomb.saga.alpha.core.TxEventRepository;
import org.apache.servicecomb.saga.alpha.server.TxEventEnvelopeRepository;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

class SpringTxEventRepository
implements TxEventRepository {
    private static final PageRequest SINGLE_TX_EVENT_REQUEST = new PageRequest(0, 1);
    private final TxEventEnvelopeRepository eventRepo;

    SpringTxEventRepository(TxEventEnvelopeRepository eventRepo) {
        this.eventRepo = eventRepo;
    }

    public void save(TxEvent event) {
        this.eventRepo.save((Object)event);
    }

    public Optional<TxEvent> findFirstAbortedGlobalTransaction() {
        return this.eventRepo.findFirstAbortedGlobalTxByType();
    }

    public List<TxEvent> findTimeoutEvents() {
        return this.eventRepo.findTimeoutEvents((Pageable)SINGLE_TX_EVENT_REQUEST);
    }

    public Optional<TxEvent> findTxStartedEventToCompensate(String globalTxId, String localTxId) {
        return this.eventRepo.findFirstStartedEventByGlobalTxIdAndLocalTxId(globalTxId, localTxId);
    }

    public List<TxEvent> findTransactions(String globalTxId, String type) {
        return this.eventRepo.findByEventGlobalTxIdAndEventType(globalTxId, type);
    }

    public List<TxEvent> findFirstUncompensatedEventByIdGreaterThan(long id, String type) {
        return this.eventRepo.findFirstByTypeAndSurrogateIdGreaterThan(type, id, (Pageable)SINGLE_TX_EVENT_REQUEST);
    }

    public Optional<TxEvent> findFirstCompensatedEventByIdGreaterThan(long id, String type) {
        return this.eventRepo.findFirstByTypeAndSurrogateIdGreaterThan(type, id);
    }

    public void deleteDuplicateEvents(String type) {
        this.eventRepo.deleteByType(type);
    }
}

