/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.alpha.server;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import org.apache.servicecomb.saga.alpha.server.ServerStartable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcStartable
implements ServerStartable {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Server server;

    GrpcStartable(int port, BindableService ... services) {
        ServerBuilder serverBuilder = ServerBuilder.forPort((int)port);
        Arrays.stream(services).forEach(arg_0 -> ((ServerBuilder)serverBuilder).addService(arg_0));
        this.server = serverBuilder.build();
    }

    public void start() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((Server)this.server).shutdown()));
        try {
            this.server.start();
            this.server.awaitTermination();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to start grpc server.", e);
        }
        catch (InterruptedException e) {
            LOG.error("grpc server was interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

