/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.alpha.server;

import java.util.List;
import javax.persistence.LockModeType;
import javax.transaction.Transactional;
import org.apache.servicecomb.saga.alpha.core.Command;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;

public interface CommandEntityRepository
extends CrudRepository<Command, Long> {
    @Transactional
    @Modifying(clearAutomatically=true)
    @Query(value="UPDATE org.apache.servicecomb.saga.alpha.core.Command c SET c.status = :status WHERE c.globalTxId = :globalTxId AND c.localTxId = :localTxId")
    public void updateStatusByGlobalTxIdAndLocalTxId(@Param(value="status") String var1, @Param(value="globalTxId") String var2, @Param(value="localTxId") String var3);

    public List<Command> findByGlobalTxIdAndStatus(String var1, String var2);

    @Lock(value=LockModeType.OPTIMISTIC)
    @Query(value="SELECT * FROM Command AS c WHERE c.eventId IN ( SELECT MAX(c1.eventId) FROM Command AS c1  INNER JOIN Command AS c2 on c1.globalTxId = c2.globalTxId WHERE c1.status = 'NEW'  GROUP BY c1.globalTxId  HAVING MAX( CASE c2.status WHEN 'PENDING' THEN 1 ELSE 0 END ) = 0) ORDER BY c.eventId ASC LIMIT 1", nativeQuery=true)
    public List<Command> findFirstGroupByGlobalTxIdWithoutPendingOrderByIdDesc();
}

