/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.alpha.server;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.servicecomb.saga.alpha.server.AlphaEventController;
import org.apache.servicecomb.saga.alpha.server.TxEventEnvelopeRepository;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/"})
class AlphaEventController {
    private final TxEventEnvelopeRepository eventRepository;

    AlphaEventController(TxEventEnvelopeRepository eventRepository) {
        this.eventRepository = eventRepository;
    }

    @GetMapping(value={"/events"})
    ResponseEntity<Collection<TxEventVo>> events() {
        Iterable events = this.eventRepository.findAll();
        LinkedList eventVos = new LinkedList();
        events.forEach(event -> eventVos.add(new TxEventVo(event, null)));
        return ResponseEntity.ok(eventVos);
    }

    @DeleteMapping(value={"/events"})
    ResponseEntity<String> clear() {
        this.eventRepository.deleteAll();
        return ResponseEntity.ok((Object)"All events deleted");
    }
}

