/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.common;

import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environment {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Environment instance = new Environment();
    private static final int PAYLOADS_MAX_LENGTH = 10240;
    private int payloadsMaxLength = 0;

    public Environment() {
        if (this.payloadsMaxLength == 0) {
            String val = System.getenv("PAYLOADS_MAX_LENGTH");
            if (val == null || val.trim().length() == 0) {
                this.payloadsMaxLength = 10240;
            } else {
                try {
                    this.payloadsMaxLength = Integer.parseInt(val);
                }
                catch (NumberFormatException ex) {
                    this.payloadsMaxLength = 10240;
                    LOG.error("Failed to parse environment variable PAYLOADS_MAX_LENGTH={}, use default value {}", (Object)val, (Object)10240);
                }
            }
        }
    }

    public static Environment getInstance() {
        return instance;
    }

    public int getPayloadsMaxLength() {
        return this.payloadsMaxLength;
    }
}

