/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.common;

import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environment {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Environment instance;
    private static final int PAYLOADS_MAX_LENGTH = 10240;
    private int payloadsMaxLength = 0;

    public Environment() {
        if (this.payloadsMaxLength == 0) {
            String val = System.getenv("PAYLOADS_MAX_LENGTH");
            if (val == null || val.trim().length() == 0) {
                this.payloadsMaxLength = 10240;
            } else {
                try {
                    this.payloadsMaxLength = Integer.parseInt(val);
                }
                catch (NumberFormatException ex) {
                    this.payloadsMaxLength = 10240;
                    LOG.error("Failed to parse environment variable PAYLOADS_MAX_LENGTH={}, use default value {}", (Object)val, (Object)10240);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Environment getInstance() {
        if (instance != null) return instance;
        Class<Environment> clazz = Environment.class;
        synchronized (Environment.class) {
            if (instance != null) return instance;
            instance = new Environment();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public int getPayloadsMaxLength() {
        return this.payloadsMaxLength;
    }
}

