/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transport.resttemplate;

import java.lang.invoke.MethodHandles;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

class TransactionHandlerInterceptor
implements HandlerInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OmegaContext omegaContext;

    TransactionHandlerInterceptor(OmegaContext omegaContext) {
        this.omegaContext = omegaContext;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (this.omegaContext != null) {
            String globalTxId = request.getHeader("X-Pack-Global-Transaction-Id");
            if (globalTxId == null) {
                LOG.debug("Cannot inject transaction ID, no such header: {}", (Object)"X-Pack-Global-Transaction-Id");
            } else {
                this.omegaContext.setGlobalTxId(globalTxId);
                this.omegaContext.setLocalTxId(request.getHeader("X-Pack-Local-Transaction-Id"));
            }
        } else {
            LOG.debug("Cannot inject transaction ID, as the OmegaContext is null.");
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object o, ModelAndView mv) {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object o, Exception e) {
    }
}

