/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.provider.consumer;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public class SyncResponseExecutor
implements Executor {
    private final CountDownLatch latch = new CountDownLatch(1);
    private Runnable cmd;
    private Response response;

    @Override
    public void execute(Runnable cmd) {
        this.cmd = cmd;
        this.latch.countDown();
    }

    public Response waitResponse(Invocation invocation) throws InvocationException {
        this.guardedWait(invocation);
        if (this.cmd != null) {
            this.cmd.run();
        }
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
        if (this.cmd == null) {
            this.latch.countDown();
        }
    }

    private void guardedWait(Invocation invocation) throws InvocationException {
        long wait = this.getWaitTime(invocation);
        try {
            if (wait <= 0L) {
                this.latch.await();
                return;
            }
            if (this.latch.await(wait, TimeUnit.MILLISECONDS)) {
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        throw new InvocationException((Response.StatusType)Response.Status.REQUEST_TIMEOUT, "SCB.00000004", "Invocation Timeout.");
    }

    private long getWaitTime(Invocation invocation) {
        if (invocation.getOperationMeta().getConfig().getMsInvocationTimeout() > 0L) {
            return invocation.getOperationMeta().getConfig().getMsInvocationTimeout();
        }
        return invocation.getOperationMeta().getConfig().getMsRequestTimeout() * 2L;
    }
}

