/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.test.scaffolding.log;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;

public class LogCollector
implements Closeable {
    List<LoggingEvent> events = new ArrayList<LoggingEvent>();
    Appender appender = new AppenderSkeleton(){

        public void append(LoggingEvent event) {
            LogCollector.this.events.add(event);
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }
    };

    public LogCollector() {
        Logger.getRootLogger().addAppender(this.appender);
    }

    public LogCollector setLogLevel(String logName, Level level) {
        Logger.getLogger((String)logName).setLevel(level);
        return this;
    }

    public List<LoggingEvent> getEvents() {
        return this.events;
    }

    public LoggingEvent getLastEvents() {
        return this.events.get(this.events.size() - 1);
    }

    public List<Throwable> getThrowables() {
        return this.events.stream().filter(e -> e.getThrowableInformation() != null).map(e -> e.getThrowableInformation().getThrowable()).collect(Collectors.toList());
    }

    public List<String> getThrowableMessages() {
        return this.events.stream().filter(e -> e.getThrowableInformation() != null).map(e -> e.getThrowableInformation().getThrowable().getMessage()).collect(Collectors.toList());
    }

    public void teardown() {
        Logger.getRootLogger().removeAppender(this.appender);
    }

    public void clear() {
        this.events = new ArrayList<LoggingEvent>();
    }

    @Override
    public void close() {
        this.teardown();
    }
}

