/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.definition;

import io.swagger.models.Operation;
import io.swagger.models.parameters.Parameter;
import java.util.concurrent.Executor;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.definition.InvocationRuntimeType;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationConfig;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.foundation.common.VendorExtensions;
import org.apache.servicecomb.swagger.engine.SwaggerProducerOperation;
import org.apache.servicecomb.swagger.generator.core.model.SwaggerOperation;
import org.apache.servicecomb.swagger.invocation.arguments.ArgumentsMapper;
import org.apache.servicecomb.swagger.invocation.response.ResponsesMeta;

public class OperationMeta {
    private SchemaMeta schemaMeta;
    private String schemaQualifiedName;
    private String microserviceQualifiedName;
    private String httpMethod;
    private String operationPath;
    private Operation swaggerOperation;
    private Executor executor;
    private ResponsesMeta responsesMeta = new ResponsesMeta();
    private OperationConfig config;
    private VendorExtensions vendorExtensions = new VendorExtensions();

    public OperationMeta init(SchemaMeta schemaMeta, SwaggerOperation swaggerOperation) {
        this.schemaMeta = schemaMeta;
        this.schemaQualifiedName = schemaMeta.getSchemaId() + "." + swaggerOperation.getOperationId();
        this.microserviceQualifiedName = schemaMeta.getMicroserviceQualifiedName() + "." + swaggerOperation.getOperationId();
        this.httpMethod = swaggerOperation.getHttpMethod().name();
        this.operationPath = swaggerOperation.getPath();
        this.swaggerOperation = swaggerOperation.getOperation();
        this.executor = schemaMeta.getMicroserviceMeta().getScbEngine().getExecutorManager().findExecutor(this);
        this.config = schemaMeta.getMicroserviceMeta().getMicroserviceVersionsMeta().getOrCreateOperationConfig(this);
        this.responsesMeta.init(schemaMeta.getSwagger(), swaggerOperation.getOperation());
        return this;
    }

    public void setSwaggerProducerOperation(SwaggerProducerOperation swaggerProducerOperation) {
        this.putExtData("producer-operation", swaggerProducerOperation);
    }

    public SwaggerProducerOperation getSwaggerProducerOperation() {
        return (SwaggerProducerOperation)this.getExtData("producer-operation");
    }

    public OperationConfig getConfig() {
        return this.config;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getOperationPath() {
        return this.operationPath;
    }

    public Operation getSwaggerOperation() {
        return this.swaggerOperation;
    }

    public ResponsesMeta getResponsesMeta() {
        return this.responsesMeta;
    }

    private ResponsesMeta cloneResponseMeta() {
        ResponsesMeta result = new ResponsesMeta();
        this.responsesMeta.cloneTo(result);
        return result;
    }

    public MicroserviceMeta getMicroserviceMeta() {
        return this.schemaMeta.getMicroserviceMeta();
    }

    public SchemaMeta getSchemaMeta() {
        return this.schemaMeta;
    }

    public String getSchemaQualifiedName() {
        return this.schemaQualifiedName;
    }

    public String getMicroserviceQualifiedName() {
        return this.microserviceQualifiedName;
    }

    public String getMicroserviceName() {
        return this.schemaMeta.getMicroserviceName();
    }

    public String getSchemaId() {
        return this.schemaMeta.getSchemaId();
    }

    public String getOperationId() {
        return this.swaggerOperation.getOperationId();
    }

    public String getParamName(int idx) {
        return ((Parameter)this.swaggerOperation.getParameters().get(idx)).getName();
    }

    public void putExtData(String key, Object data) {
        this.vendorExtensions.put((Object)key, data);
    }

    public <T> T getExtData(String key) {
        return (T)this.vendorExtensions.get((Object)key);
    }

    public VendorExtensions getVendorExtensions() {
        return this.vendorExtensions;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Deprecated
    public Handler getProviderQpsFlowControlHandler() {
        return this.getMicroserviceMeta().getProviderQpsFlowControlHandler();
    }

    public InvocationRuntimeType buildBaseProviderRuntimeType() {
        SwaggerProducerOperation swaggerProducerOperation = this.getSwaggerProducerOperation();
        return new InvocationRuntimeType(swaggerProducerOperation.getProducerClass(), swaggerProducerOperation.getProducerMethod(), this.cloneResponseMeta(), (ArgumentsMapper)swaggerProducerOperation.getArgumentsMapper());
    }

    public InvocationRuntimeType buildBaseConsumerRuntimeType() {
        return new InvocationRuntimeType(this.cloneResponseMeta());
    }
}

