/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.edge.core;

import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.DynamicPropertyFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.edge.core.URLMappedConfigurationItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLMappedConfigurationLoader {
    private static final Logger LOG = LoggerFactory.getLogger(URLMappedConfigurationLoader.class);
    private static final String KEY_MAPPING_PATH = ".path";
    private static final String KEY_MAPPING_SERVICE_NAME = "%s.%s.microserviceName";
    private static final String KEY_MAPPING_VERSION_RULE = "%s.%s.versionRule";
    private static final String KEY_MAPPING_PREFIX_SEGMENT_COUNT = "%s.%s.prefixSegmentCount";

    public static Map<String, URLMappedConfigurationItem> loadConfigurations(ConcurrentCompositeConfiguration config, String configPrefix) {
        HashMap<String, URLMappedConfigurationItem> configurations = new HashMap<String, URLMappedConfigurationItem>();
        Iterator configsItems = config.getKeys(configPrefix);
        while (configsItems.hasNext()) {
            String pathKey = (String)configsItems.next();
            if (!pathKey.endsWith(KEY_MAPPING_PATH)) continue;
            URLMappedConfigurationItem configurationItem = new URLMappedConfigurationItem();
            String pattern = DynamicPropertyFactory.getInstance().getStringProperty(pathKey, null).get();
            if (StringUtils.isEmpty((CharSequence)pattern)) continue;
            configurationItem.setPattern(Pattern.compile(pattern));
            configurationItem.setStringPattern(pattern);
            String pathKeyItem = pathKey.substring(configPrefix.length() + 1, pathKey.length() - KEY_MAPPING_PATH.length());
            configurationItem.setMicroserviceName(DynamicPropertyFactory.getInstance().getStringProperty(String.format(KEY_MAPPING_SERVICE_NAME, configPrefix, pathKeyItem), null).get());
            if (StringUtils.isEmpty((CharSequence)configurationItem.getMicroserviceName())) continue;
            configurationItem.setPrefixSegmentCount(DynamicPropertyFactory.getInstance().getIntProperty(String.format(KEY_MAPPING_PREFIX_SEGMENT_COUNT, configPrefix, pathKeyItem), 0).get());
            configurationItem.setVersionRule(DynamicPropertyFactory.getInstance().getStringProperty(String.format(KEY_MAPPING_VERSION_RULE, configPrefix, pathKeyItem), "0.0.0+").get());
            configurations.put(pathKeyItem, configurationItem);
        }
        URLMappedConfigurationLoader.logConfigurations(configurations);
        return configurations;
    }

    private static void logConfigurations(Map<String, URLMappedConfigurationItem> configurations) {
        configurations.entrySet().forEach(stringConfigurationItemEntry -> {
            URLMappedConfigurationItem item = (URLMappedConfigurationItem)stringConfigurationItemEntry.getValue();
            LOG.info("config item: key=" + (String)stringConfigurationItemEntry.getKey() + ";pattern=" + item.getStringPattern() + ";service=" + item.getMicroserviceName() + ";versionRule=" + item.getVersionRule());
        });
    }
}

