/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.edge.core;

import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.rest.filter.HttpClientFilter;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.swagger.invocation.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeAddHeaderClientFilter
implements HttpClientFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(EdgeAddHeaderClientFilter.class);
    private static final String PREFIX = "servicecomb.edge.filter.addHeader";
    private static final String KEY_ENABLED = "servicecomb.edge.filter.addHeader.enabled";
    private static final String KEY_HEADERS = "servicecomb.edge.filter.addHeader.allowedHeaders";
    private List<String> publicHeaders = new ArrayList<String>();
    private boolean enabled = false;

    public EdgeAddHeaderClientFilter() {
        this.init();
        ConfigurationManager.getConfigInstance().addConfigurationListener(event -> {
            if (StringUtils.startsWith((CharSequence)event.getPropertyName(), (CharSequence)PREFIX)) {
                LOGGER.info("Public headers config have been changed. Event=" + event.getType());
                this.init();
            }
        });
    }

    private void init() {
        this.enabled = DynamicPropertyFactory.getInstance().getBooleanProperty(KEY_ENABLED, false).get();
        String publicHeaderStr = DynamicPropertyFactory.getInstance().getStringProperty(KEY_HEADERS, "").get();
        String[] split = publicHeaderStr.split(",");
        if (split.length > 0) {
            this.publicHeaders = Arrays.asList(split);
        }
    }

    public int getOrder() {
        return 0;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void beforeSendRequest(Invocation invocation, HttpServletRequestEx requestEx) {
        this.addHeaders(invocation, (arg_0, arg_1) -> ((HttpServletRequestEx)requestEx).addHeader(arg_0, arg_1));
    }

    public void addHeaders(Invocation invocation, BiConsumer<String, String> headerAdder) {
        if (!invocation.isEdge()) {
            return;
        }
        HttpServletRequestEx oldRequest = invocation.getRequestEx();
        this.publicHeaders.forEach(key -> {
            String value = oldRequest.getHeader(key);
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                headerAdder.accept((String)key, value);
            }
        });
    }

    public Response afterReceiveResponse(Invocation invocation, HttpServletResponseEx responseEx) {
        return null;
    }
}

