/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.huaweicloud.dashboard.monitor.data;

import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixEventType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.data.Diagnosis;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.data.InterfaceInfo;
import org.apache.servicecomb.serviceregistry.diagnosis.instance.InstanceCacheResult;

public class MonitorData {
    private static final double PERCENTAGE_995 = 99.5;
    private static final double PERCENTAGE_99 = 99.0;
    private static final double PERCENTAGE_90 = 90.0;
    private static final double PERCENTAGE_75 = 75.0;
    private static final double PERCENTAGE_50 = 50.0;
    private static final double PERCENTAGE_25 = 25.0;
    private static final double PERCENTAGE_5 = 5.0;
    private static final int SCALE_VAL = 1;
    private static final double DEFAULT_SUCCESS_RATE = 1.0;
    private String appId;
    private String version;
    private String name;
    private String serviceId;
    private String instance;
    private String instanceId;
    private int thread;
    private double cpu;
    private double loadAverage;
    private long uptime;
    private Map<String, Long> memory;
    private List<InterfaceInfo> interfaces = new ArrayList<InterfaceInfo>();
    private Diagnosis diagnosis;
    private Map<String, Object> customs;
    private static final int CONVERSION = 1000;
    private List<InstanceCacheResult> providersCache;

    public void appendInterfaceInfo(HystrixCommandMetrics metrics) {
        InterfaceInfo interfaceInfo = new InterfaceInfo();
        int windowTime = (Integer)metrics.getProperties().metricsRollingStatisticalWindowInMilliseconds().get() / 1000;
        long successCount = metrics.getRollingCount(HystrixEventType.SUCCESS);
        long failureCount = metrics.getRollingCount(HystrixEventType.FAILURE);
        long semRejectCount = metrics.getRollingCount(HystrixEventType.SEMAPHORE_REJECTED);
        long threadRejectCount = metrics.getRollingCount(HystrixEventType.THREAD_POOL_REJECTED);
        long timeoutCount = metrics.getRollingCount(HystrixEventType.TIMEOUT);
        long shortCircuitedCount = metrics.getRollingCount(HystrixEventType.SHORT_CIRCUITED);
        long rollingErrorTotal = failureCount + semRejectCount + threadRejectCount + timeoutCount;
        long rollingTotal = successCount + rollingErrorTotal;
        if (rollingTotal == 0L) {
            interfaceInfo.setRate(1.0);
            interfaceInfo.setFailureRate(0.0);
        } else {
            double failurePercentage = (double)rollingErrorTotal / (double)rollingTotal;
            interfaceInfo.setRate(1.0 - failurePercentage);
            interfaceInfo.setFailureRate(failurePercentage);
        }
        int latency = metrics.getTotalTimeMean();
        int latency995 = metrics.getTotalTimePercentile(99.5);
        int latency99 = metrics.getTotalTimePercentile(99.0);
        int latency90 = metrics.getTotalTimePercentile(90.0);
        int latency75 = metrics.getTotalTimePercentile(75.0);
        int latency50 = metrics.getTotalTimePercentile(50.0);
        int latency25 = metrics.getTotalTimePercentile(25.0);
        int latency5 = metrics.getTotalTimePercentile(5.0);
        interfaceInfo.setName(metrics.getCommandKey().name());
        interfaceInfo.setCircuitBreakerOpen(this.isOpen(metrics));
        interfaceInfo.setShortCircuited(shortCircuitedCount);
        interfaceInfo.setFailureRate(failureCount);
        interfaceInfo.setSemaphoreRejected(semRejectCount);
        interfaceInfo.setThreadPoolRejected(threadRejectCount);
        interfaceInfo.setCountTimeout(timeoutCount);
        interfaceInfo.setDesc(metrics.getCommandKey().name());
        interfaceInfo.setLatency(latency);
        interfaceInfo.setL995(latency995);
        interfaceInfo.setL99(latency99);
        interfaceInfo.setL90(latency90);
        interfaceInfo.setL75(latency75);
        interfaceInfo.setL50(latency50);
        interfaceInfo.setL25(latency25);
        interfaceInfo.setL5(latency5);
        interfaceInfo.setTotal(rollingTotal);
        double qpsVal = (double)rollingTotal / (double)windowTime;
        BigDecimal b = new BigDecimal(qpsVal);
        BigDecimal qps = b.setScale(1, RoundingMode.HALF_DOWN);
        interfaceInfo.setQps(qps.doubleValue());
        this.interfaces.add(interfaceInfo);
    }

    public boolean isOpen(HystrixCommandMetrics metrics) {
        if (((Boolean)metrics.getProperties().circuitBreakerForceOpen().get()).booleanValue()) {
            return true;
        }
        if (((Boolean)metrics.getProperties().circuitBreakerForceClosed().get()).booleanValue()) {
            return false;
        }
        HystrixCircuitBreaker circuitBreaker = HystrixCircuitBreaker.Factory.getInstance((HystrixCommandKey)metrics.getCommandKey());
        return circuitBreaker != null && circuitBreaker.isOpen();
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public int getThreadCount() {
        return this.thread;
    }

    public void setThreadCount(int threadCount) {
        this.thread = threadCount;
    }

    public double getCpu() {
        return this.cpu;
    }

    public void setCpu(double cpu) {
        this.cpu = cpu;
    }

    public double getLoadAverage() {
        return this.loadAverage;
    }

    public void setLoadAverage(double loadAverage) {
        this.loadAverage = loadAverage;
    }

    public long getUptime() {
        return this.uptime;
    }

    public void setUptime(long uptime) {
        this.uptime = uptime;
    }

    public Map<String, Long> getMemory() {
        return this.memory;
    }

    public void setMemory(Map<String, Long> memory) {
        this.memory = memory;
    }

    public List<InterfaceInfo> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(List<InterfaceInfo> interfaces) {
        this.interfaces = interfaces;
    }

    public Diagnosis getDiagnosis() {
        return this.diagnosis;
    }

    public void setDiagnosis(Diagnosis diagnosis) {
        this.diagnosis = diagnosis;
    }

    public Map<String, Object> getCustoms() {
        return this.customs;
    }

    public void setCustoms(Map<String, Object> customs) {
        this.customs = customs;
    }

    public List<InstanceCacheResult> getProvidersCache() {
        return this.providersCache;
    }

    public void setProvidersCache(List<InstanceCacheResult> providersCache) {
        this.providersCache = providersCache;
    }
}

