/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.huaweicloud.dashboard.monitor;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.json.Json;
import io.vertx.core.net.ProxyOptions;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.servicecomb.foundation.auth.SignRequest;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.apache.servicecomb.foundation.ssl.SSLCustom;
import org.apache.servicecomb.foundation.ssl.SSLOption;
import org.apache.servicecomb.foundation.ssl.SSLOptionFactory;
import org.apache.servicecomb.foundation.vertx.AddressResolverConfig;
import org.apache.servicecomb.foundation.vertx.VertxTLSBuilder;
import org.apache.servicecomb.foundation.vertx.VertxUtils;
import org.apache.servicecomb.foundation.vertx.client.ClientPoolFactory;
import org.apache.servicecomb.foundation.vertx.client.ClientPoolManager;
import org.apache.servicecomb.foundation.vertx.client.ClientVerticle;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientPoolFactory;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientWithContext;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.AddressManager;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.SignUtil;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.data.MonitorConstant;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.event.MonitorFailEvent;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.event.MonitorSuccEvent;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.model.MonitorDaraProvider;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.model.MonitorDataPublisher;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMonitorDataPublisher
implements MonitorDataPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMonitorDataPublisher.class);
    private static final String SSL_KEY = "mc.consumer";
    private static final int MAX_WAIT_QUEUE_SIZE = 50;
    private static ClientPoolManager<HttpClientWithContext> clientMgr;
    private AddressManager addressManager = new AddressManager();

    @Override
    public void init() {
        try {
            this.deployMonitorClient();
        }
        catch (Exception e) {
            LOGGER.warn("Deploy monitor data publisher failed will not send monitor data.");
        }
    }

    @Override
    public void publish(MonitorDaraProvider provider) {
        Object data = provider.getData();
        if (data == null) {
            return;
        }
        String endpoint = this.addressManager.nextServer();
        if (endpoint == null) {
            return;
        }
        String jasonData = Json.encode((Object)data);
        String url = provider.getURL();
        IpPort host = NetUtils.parseIpPortFromURI((String)endpoint);
        this.doSend(endpoint, jasonData, url, host, 0);
    }

    private void doSend(String endpoint, String jsonData, String url, IpPort host, int times) {
        ((HttpClientWithContext)clientMgr.findThreadBindClientPool()).runOnContext(client -> {
            HttpClientRequest request = client.post(host.getPort(), host.getHostOrIp(), url, rsp -> {
                rsp.exceptionHandler(e -> LOGGER.warn("publish error ", e));
                if (rsp.statusCode() != HttpResponseStatus.OK.code()) {
                    if (times < 3 && rsp.statusCode() == HttpResponseStatus.BAD_GATEWAY.code()) {
                        this.doSend(endpoint, jsonData, url, host, times + 1);
                        return;
                    }
                    rsp.bodyHandler(buffer -> {
                        LOGGER.warn("Send data to url {} failed and status line is {}", (Object)url, (Object)rsp.statusCode());
                        LOGGER.warn("message: {}", buffer);
                    });
                    EventManager.post((Object)new MonitorFailEvent("send monitor data fail."));
                } else {
                    EventManager.post((Object)new MonitorSuccEvent());
                }
            });
            request.setTimeout((long)(MonitorConstant.getInterval() / 3));
            request.exceptionHandler(e -> {
                EventManager.post((Object)new MonitorFailEvent("send monitor data fail."));
                LOGGER.warn("Send monitor data to {} failed , {}", (Object)endpoint, (Object)e.getMessage());
                if (e instanceof UnknownHostException) {
                    LOGGER.error("DNS resolve failed!", e);
                }
            });
            try {
                SignRequest signReq = SignUtil.createSignRequest(request.method().toString(), endpoint + url, new HashMap<String, String>(), IOUtils.toInputStream((String)jsonData, (String)"UTF-8"));
                SignUtil.getAuthHeaderProviders().forEach(authHeaderProvider -> request.headers().addAll(authHeaderProvider.getSignAuthHeaders(signReq)));
                request.headers().add("environment", RegistryUtils.getMicroservice().getEnvironment());
            }
            catch (Exception e2) {
                LOGGER.error("sign request error!", (Throwable)e2);
            }
            request.end(jsonData);
        });
    }

    private void deployMonitorClient() throws InterruptedException {
        VertxOptions vertxOptions = new VertxOptions();
        vertxOptions.setAddressResolverOptions(AddressResolverConfig.getAddressResover((String)SSL_KEY));
        Vertx vertx = VertxUtils.getOrCreateVertxByName((String)"monitor-center", (VertxOptions)vertxOptions);
        HttpClientOptions httpClientOptions = this.createHttpClientOptions();
        httpClientOptions.setMaxWaitQueueSize(50);
        clientMgr = new ClientPoolManager(vertx, (ClientPoolFactory)new HttpClientPoolFactory(httpClientOptions));
        DeploymentOptions deploymentOptions = VertxUtils.createClientDeployOptions(clientMgr, (int)1);
        VertxUtils.blockDeploy((Vertx)vertx, ClientVerticle.class, (DeploymentOptions)deploymentOptions);
    }

    private HttpClientOptions createHttpClientOptions() {
        HttpClientOptions httpClientOptions = new HttpClientOptions();
        if (MonitorConstant.isProxyEnable().booleanValue()) {
            ProxyOptions proxy = new ProxyOptions();
            proxy.setHost(MonitorConstant.getProxyHost());
            proxy.setPort(MonitorConstant.getProxyPort());
            proxy.setUsername(MonitorConstant.getProxyUsername());
            proxy.setPassword(MonitorConstant.getProxyPasswd());
            httpClientOptions.setProxyOptions(proxy);
        }
        httpClientOptions.setConnectTimeout(MonitorConstant.getConnectionTimeout());
        if (MonitorConstant.sslEnabled()) {
            SSLOptionFactory factory = SSLOptionFactory.createSSLOptionFactory((String)SSL_KEY, null);
            SSLOption sslOption = factory == null ? SSLOption.buildFromYaml((String)SSL_KEY) : factory.createSSLOption();
            SSLCustom sslCustom = SSLCustom.createSSLCustom((String)sslOption.getSslCustomClass());
            VertxTLSBuilder.buildHttpClientOptions((SSLOption)sslOption, (SSLCustom)sslCustom, (HttpClientOptions)httpClientOptions);
        }
        return httpClientOptions;
    }
}

