/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.huaweicloud.dashboard.monitor;

import java.util.ArrayList;
import java.util.List;
import org.apache.servicecomb.deployment.Deployment;
import org.apache.servicecomb.deployment.SystemBootstrapInfo;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.RegistryUtils;

public class AddressManager {
    private static final String MONITOR_SERVICE_NAME = "CseMonitoring";
    private static final String MONITOR_APPLICATION = "default";
    private static final String MONITOR_VERSION = "latest";
    private final List<String> addresses = new ArrayList<String>();
    private int index = 0;

    AddressManager() {
        this.updateAddresses();
        this.updateServersFromSC();
        EventManager.register((Object)this);
    }

    private void updateAddresses() {
        SystemBootstrapInfo info = Deployment.getSystemBootStrapInfo((String)"DashboardService");
        if (info != null && info.getAccessURL() != null) {
            this.addresses.addAll(info.getAccessURL());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String nextServer() {
        AddressManager addressManager = this;
        synchronized (addressManager) {
            ++this.index;
            if (this.index >= this.addresses.size()) {
                this.index = 0;
            }
            return this.addresses.get(this.index);
        }
    }

    private void updateServersFromSC() {
        List servers = RegistryUtils.findServiceInstance((String)MONITOR_APPLICATION, (String)MONITOR_SERVICE_NAME, (String)MONITOR_VERSION);
        if (servers != null) {
            for (MicroserviceInstance server : servers) {
                for (String endpoint : server.getEndpoints()) {
                    if (this.addresses.contains(endpoint)) continue;
                    this.addresses.add(endpoint);
                }
            }
        }
    }
}

